package com.dji.wpmzsdk.common.utils.kml.transfrom;



import com.dji.wpmzsdk.common.utils.kml.mission.WaypointMissionGotoWaypointMode;

import dji.sdk.wpmz.value.mission.WaylineFlyToWaylineMode;

/**
 * Description :
 *
 * @author : devin.xu
 * @filename : WaylineToFirstPointTransform
 * @time : 2020/11/25
 * <p>
 * Copyright (c) 2016, DJI All Rights Reserved.
 **/
public class WaylineToFirstPointTransform implements ModelTransform<WaypointMissionGotoWaypointMode, WaylineFlyToWaylineMode> {
    @Override
    public WaylineFlyToWaylineMode transFrom(WaypointMissionGotoWaypointMode waypointMissionGotoFirstWaypointMode) {
        if (waypointMissionGotoFirstWaypointMode != null) {
            switch (waypointMissionGotoFirstWaypointMode) {
                case GotoWaypointSafely:
                    return WaylineFlyToWaylineMode.SAFELY;
                case GotoWaypointPointToPoint:
                    return WaylineFlyToWaylineMode.POINT_TO_POINT;
                default:
                    return WaylineFlyToWaylineMode.SAFELY;
            }
        }
        return WaylineFlyToWaylineMode.SAFELY;
    }

    @Override
    public WaypointMissionGotoWaypointMode transTo(WaylineFlyToWaylineMode waylineFlyToWaylineMode) {
        if (waylineFlyToWaylineMode != null) {
            switch (waylineFlyToWaylineMode) {
                case SAFELY:
                    return WaypointMissionGotoWaypointMode.GotoWaypointSafely;
                case POINT_TO_POINT:
                    return WaypointMissionGotoWaypointMode.GotoWaypointPointToPoint;
                default:
                    return WaypointMissionGotoWaypointMode.GotoWaypointSafely;
            }
        }
        return WaypointMissionGotoWaypointMode.GotoWaypointSafely;
    }
}
