/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.minlog.Log;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionFieldSerializer<T>
extends FieldSerializer<T> {
    private int typeVersion = 0;
    private int[] fieldVersion;
    private boolean compatible = true;

    public VersionFieldSerializer(Kryo kryo, Class type) {
        super(kryo, type);
        this.initializeCachedFields();
    }

    public VersionFieldSerializer(Kryo kryo, Class type, boolean compatible) {
        this(kryo, type);
        this.compatible = compatible;
    }

    @Override
    protected void initializeCachedFields() {
        FieldSerializer.CachedField[] fields = this.getFields();
        this.fieldVersion = new int[fields.length];
        int n = fields.length;
        for (int i = 0; i < n; ++i) {
            Field field = fields[i].getField();
            Since since = field.getAnnotation(Since.class);
            if (since != null) {
                this.fieldVersion[i] = since.value();
                this.typeVersion = Math.max(this.fieldVersion[i], this.typeVersion);
                continue;
            }
            this.fieldVersion[i] = 0;
        }
        this.removedFields.clear();
        if (Log.DEBUG) {
            Log.debug((String)("Version for type " + this.getType().getName() + " is " + this.typeVersion));
        }
    }

    @Override
    public void removeField(String fieldName) {
        super.removeField(fieldName);
        this.initializeCachedFields();
    }

    @Override
    public void removeField(FieldSerializer.CachedField field) {
        super.removeField(field);
        this.initializeCachedFields();
    }

    @Override
    public void write(Kryo kryo, Output output, T object) {
        FieldSerializer.CachedField[] fields = this.getFields();
        output.writeVarInt(this.typeVersion, true);
        int n = fields.length;
        for (int i = 0; i < n; ++i) {
            fields[i].write(output, object);
        }
    }

    @Override
    public T read(Kryo kryo, Input input, Class<T> type) {
        T object = this.create(kryo, input, type);
        kryo.reference(object);
        int version = input.readVarInt(true);
        if (!this.compatible && version != this.typeVersion) {
            throw new KryoException("Version not compatible: " + version + " <-> " + this.typeVersion);
        }
        FieldSerializer.CachedField[] fields = this.getFields();
        int n = fields.length;
        for (int i = 0; i < n; ++i) {
            if (this.fieldVersion[i] > version) {
                if (!Log.DEBUG) continue;
                Log.debug((String)("Skip field " + fields[i].getField().getName()));
                continue;
            }
            fields[i].read(input, object);
        }
        return object;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Since {
        public int value() default 0;
    }
}

