/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.ResourceFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleResourceFactory
implements ResourceFactory {
    private Logger log = LoggerFactory.getLogger(MultipleResourceFactory.class);
    protected final List<ResourceFactory> factories;
    protected Map<String, ResourceFactory> mapOfFactoriesByHost;

    public MultipleResourceFactory() {
        this.factories = new ArrayList<ResourceFactory>();
    }

    public MultipleResourceFactory(List<ResourceFactory> factories) {
        this.factories = factories;
    }

    @Override
    public Resource getResource(String host, String url) {
        Resource theResource;
        if (this.log.isTraceEnabled()) {
            this.log.trace("getResource: " + url);
        }
        ResourceFactory hostRf = null;
        if (this.mapOfFactoriesByHost != null) {
            hostRf = this.mapOfFactoriesByHost.get(host);
        }
        if ((theResource = hostRf != null ? hostRf.getResource(host, url) : this.findFromFactories(host, url)) == null) {
            this.log.debug("no resource factory supplied a resouce");
        }
        return theResource;
    }

    public Map<String, ResourceFactory> getMapOfFactoriesByHost() {
        return this.mapOfFactoriesByHost;
    }

    public void setMapOfFactoriesByHost(Map<String, ResourceFactory> mapOfFactoriesByHost) {
        this.mapOfFactoriesByHost = mapOfFactoriesByHost;
    }

    private Resource findFromFactories(String host, String url) {
        for (ResourceFactory rf : this.factories) {
            Resource r = rf.getResource(host, url);
            if (r == null) continue;
            return r;
        }
        return null;
    }
}

