/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http.http11;

import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.AuthenticationService;
import com.bradmcevoy.http.GetableResource;
import com.bradmcevoy.http.Range;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.exceptions.BadRequestException;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import com.bradmcevoy.http.exceptions.NotFoundException;
import com.bradmcevoy.http.http11.CacheControlHelper;
import com.bradmcevoy.http.http11.DefaultCacheControlHelper;
import com.bradmcevoy.http.http11.DefaultETagGenerator;
import com.bradmcevoy.http.http11.ETagGenerator;
import com.bradmcevoy.http.http11.Http11ResponseHandler;
import com.bradmcevoy.io.BufferingOutputStream;
import com.bradmcevoy.io.ReadingException;
import com.bradmcevoy.io.StreamUtils;
import com.bradmcevoy.io.WritingException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttp11ResponseHandler
implements Http11ResponseHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultHttp11ResponseHandler.class);
    public static final String METHOD_NOT_ALLOWED_HTML = "<html><body><h1>Method Not Allowed</h1></body></html>";
    public static final String NOT_FOUND_HTML = "<html><body><h1>${url} Not Found (404)</h1></body></html>";
    public static final String METHOD_NOT_IMPLEMENTED_HTML = "<html><body><h1>Method Not Implemented</h1></body></html>";
    public static final String CONFLICT_HTML = "<html><body><h1>Conflict</h1></body></html>";
    public static final String SERVER_ERROR_HTML = "<html><body><h1>Server Error</h1></body></html>";
    public static final String NOT_AUTHORISED_HTML = "<html><body><h1>Not authorised</h1></body></html>";
    private final AuthenticationService authenticationService;
    private final ETagGenerator eTagGenerator;
    private CacheControlHelper cacheControlHelper = new DefaultCacheControlHelper();
    private int maxMemorySize = 100000;
    private BUFFERING buffering;

    public DefaultHttp11ResponseHandler(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
        this.eTagGenerator = new DefaultETagGenerator();
    }

    public DefaultHttp11ResponseHandler(AuthenticationService authenticationService, ETagGenerator eTagGenerator) {
        this.authenticationService = authenticationService;
        this.eTagGenerator = eTagGenerator;
    }

    public CacheControlHelper getCacheControlHelper() {
        return this.cacheControlHelper;
    }

    public void setCacheControlHelper(CacheControlHelper cacheControlHelper) {
        this.cacheControlHelper = cacheControlHelper;
    }

    @Override
    public String generateEtag(Resource r) {
        return this.eTagGenerator.generateEtag(r);
    }

    @Override
    public void respondWithOptions(Resource resource, Response response, Request request, List<String> methodsAllowed) {
        response.setStatus(Response.Status.SC_OK);
        response.setAllowHeader(methodsAllowed);
        response.setContentLengthHeader(0L);
    }

    @Override
    public void respondNotFound(Response response, Request request) {
        response.setStatus(Response.Status.SC_NOT_FOUND);
        response.setContentTypeHeader("text/html");
        PrintWriter pw = new PrintWriter(response.getOutputStream(), true);
        String s = NOT_FOUND_HTML.replace("${url}", request.getAbsolutePath());
        pw.print(s);
        pw.flush();
    }

    @Override
    public void respondUnauthorised(Resource resource, Response response, Request request) {
        log.trace("respondUnauthorised");
        response.setStatus(Response.Status.SC_UNAUTHORIZED);
        List<String> challenges = this.authenticationService.getChallenges(resource, request);
        response.setAuthenticateHeader(challenges);
    }

    @Override
    public void respondMethodNotImplemented(Resource resource, Response response, Request request) {
        try {
            response.setStatus(Response.Status.SC_NOT_IMPLEMENTED);
            OutputStream out = response.getOutputStream();
            out.write(METHOD_NOT_IMPLEMENTED_HTML.getBytes());
        }
        catch (IOException ex) {
            log.warn("exception writing content");
        }
    }

    @Override
    public void respondMethodNotAllowed(Resource res, Response response, Request request) {
        log.debug("method not allowed. handler: " + this.getClass().getName() + " resource: " + res.getClass().getName());
        try {
            response.setStatus(Response.Status.SC_METHOD_NOT_ALLOWED);
            OutputStream out = response.getOutputStream();
            out.write(METHOD_NOT_ALLOWED_HTML.getBytes());
        }
        catch (IOException ex) {
            log.warn("exception writing content");
        }
    }

    @Override
    public void respondConflict(Resource resource, Response response, Request request, String message) {
        log.debug("respondConflict");
        try {
            response.setStatus(Response.Status.SC_CONFLICT);
            OutputStream out = response.getOutputStream();
            out.write(CONFLICT_HTML.getBytes());
        }
        catch (IOException ex) {
            log.warn("exception writing content");
        }
    }

    @Override
    public void respondRedirect(Response response, Request request, String redirectUrl) {
        if (redirectUrl == null) {
            throw new NullPointerException("redirectUrl cannot be null");
        }
        log.trace("respondRedirect");
        response.sendRedirect(redirectUrl);
    }

    @Override
    public void respondExpectationFailed(Response response, Request request) {
        response.setStatus(Response.Status.SC_EXPECTATION_FAILED);
    }

    @Override
    public void respondCreated(Resource resource, Response response, Request request) {
        response.setStatus(Response.Status.SC_CREATED);
    }

    @Override
    public void respondNoContent(Resource resource, Response response, Request request) {
        response.setStatus(Response.Status.SC_NO_CONTENT);
    }

    @Override
    public void respondPartialContent(GetableResource resource, Response response, Request request, Map<String, String> params, Range range) throws NotAuthorizedException, BadRequestException, NotFoundException {
        String acc;
        String ct;
        log.debug("respondPartialContent: " + range.getStart() + " - " + range.getFinish());
        response.setStatus(Response.Status.SC_PARTIAL_CONTENT);
        response.setContentRangeHeader(range.getStart(), range.getFinish(), resource.getContentLength());
        response.setDateHeader(new Date());
        String etag = this.eTagGenerator.generateEtag(resource);
        if (etag != null) {
            response.setEtag(etag);
        }
        if ((ct = resource.getContentType(acc = request.getAcceptHeader())) != null) {
            response.setContentTypeHeader(ct);
        }
        try {
            resource.sendContent(response.getOutputStream(), range, params, ct);
        }
        catch (IOException ex) {
            log.warn("IOException writing to output, probably client terminated connection", (Throwable)ex);
        }
    }

    @Override
    public void respondHead(Resource resource, Response response, Request request) {
        this.setRespondContentCommonHeaders(response, resource, Response.Status.SC_NO_CONTENT, request.getAuthorization());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void respondContent(Resource resource, Response response, Request request, Map<String, String> params) throws NotAuthorizedException, BadRequestException, NotFoundException {
        log.debug("respondContent: " + resource.getClass());
        Auth auth = request.getAuthorization();
        this.setRespondContentCommonHeaders(response, resource, auth);
        if (resource instanceof GetableResource) {
            boolean doBuffering;
            GetableResource gr = (GetableResource)resource;
            String acc = request.getAcceptHeader();
            String ct = gr.getContentType(acc);
            if (ct != null) {
                ct = this.pickBestContentType(ct);
                response.setContentTypeHeader(ct);
            }
            this.cacheControlHelper.setCacheControl(gr, response, request.getAuthorization());
            Long contentLength = gr.getContentLength();
            if (this.buffering == null || this.buffering == BUFFERING.whenNeeded) {
                doBuffering = contentLength == null;
            } else {
                boolean bl = doBuffering = this.buffering == BUFFERING.always;
            }
            if (!doBuffering) {
                log.trace("sending content with known content length: " + contentLength);
                response.setContentLengthHeader(contentLength);
                this.sendContent(request, response, (GetableResource)resource, params, null, ct);
            } else {
                log.trace("buffering content...");
                BufferingOutputStream tempOut = new BufferingOutputStream(this.maxMemorySize);
                try {
                    ((GetableResource)resource).sendContent(tempOut, null, params, ct);
                    tempOut.close();
                }
                catch (IOException ex) {
                    tempOut.deleteTempFileIfExists();
                    throw new RuntimeException("Exception generating buffered content", ex);
                }
                Long bufContentLength = tempOut.getSize();
                if (contentLength != null && !contentLength.equals(bufContentLength)) {
                    throw new RuntimeException("Content Length specified by resource: " + contentLength + " is not equal to the size of content when generated: " + bufContentLength + " This error can be suppressed by setting the buffering property to whenNeeded or never");
                }
                log.trace("sending buffered content...");
                response.setContentLengthHeader(bufContentLength);
                InputStream in = tempOut.getInputStream();
                try {
                    StreamUtils.readTo(in, response.getOutputStream());
                }
                catch (ReadingException ex) {
                    throw new RuntimeException(ex);
                }
                catch (WritingException ex) {
                    log.warn("exception writing, client probably closed connection", (Throwable)ex);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)in);
                }
                return;
            }
        }
    }

    @Override
    public void respondNotModified(GetableResource resource, Response response, Request request) {
        log.trace("respondNotModified");
        response.setStatus(Response.Status.SC_NOT_MODIFIED);
        response.setDateHeader(new Date());
        String etag = this.eTagGenerator.generateEtag(resource);
        if (etag != null) {
            response.setEtag(etag);
        }
        Date modDate = resource.getModifiedDate();
        response.setLastModifiedHeader(modDate);
        this.cacheControlHelper.setCacheControl(resource, response, request.getAuthorization());
    }

    protected void sendContent(Request request, Response response, GetableResource resource, Map<String, String> params, Range range, String contentType) throws NotAuthorizedException, BadRequestException, NotFoundException {
        long l = System.currentTimeMillis();
        log.trace("sendContent");
        OutputStream out = this.outputStreamForResponse(request, response, resource);
        try {
            resource.sendContent(out, null, params, contentType);
            out.flush();
            if (log.isTraceEnabled()) {
                l = System.currentTimeMillis() - l;
                log.trace("sendContent finished in " + l + "ms");
            }
        }
        catch (IOException ex) {
            log.warn("IOException sending content", (Throwable)ex);
        }
    }

    protected OutputStream outputStreamForResponse(Request request, Response response, GetableResource resource) {
        OutputStream outToUse = response.getOutputStream();
        return outToUse;
    }

    protected void output(Response response, String s) {
        PrintWriter pw = new PrintWriter(response.getOutputStream(), true);
        pw.print(s);
        pw.flush();
    }

    protected void setRespondContentCommonHeaders(Response response, Resource resource, Auth auth) {
        this.setRespondContentCommonHeaders(response, resource, Response.Status.SC_OK, auth);
    }

    protected void setRespondContentCommonHeaders(Response response, Resource resource, Response.Status status, Auth auth) {
        response.setStatus(status);
        response.setDateHeader(new Date());
        String etag = this.eTagGenerator.generateEtag(resource);
        if (etag != null) {
            response.setEtag(etag);
        }
        DefaultHttp11ResponseHandler.setModifiedDate(response, resource, auth);
    }

    public static void setModifiedDate(Response response, Resource resource, Auth auth) {
        Date modDate = resource.getModifiedDate();
        if (modDate != null) {
            response.setLastModifiedHeader(modDate);
        }
    }

    @Override
    public void respondBadRequest(Resource resource, Response response, Request request) {
        response.setStatus(Response.Status.SC_BAD_REQUEST);
    }

    @Override
    public void respondForbidden(Resource resource, Response response, Request request) {
        response.setStatus(Response.Status.SC_FORBIDDEN);
    }

    @Override
    public void respondDeleteFailed(Request request, Response response, Resource resource, Response.Status status) {
        response.setStatus(status);
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    @Override
    public void respondServerError(Request request, Response response, String reason) {
        try {
            response.setStatus(Response.Status.SC_INTERNAL_SERVER_ERROR);
            OutputStream out = response.getOutputStream();
            out.write(SERVER_ERROR_HTML.getBytes());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public int getMaxMemorySize() {
        return this.maxMemorySize;
    }

    public void setMaxMemorySize(int maxMemorySize) {
        this.maxMemorySize = maxMemorySize;
    }

    public BUFFERING getBuffering() {
        return this.buffering;
    }

    public void setBuffering(BUFFERING buffering) {
        this.buffering = buffering;
    }

    private String pickBestContentType(String ct) {
        if (ct == null) {
            return null;
        }
        if (ct.contains(",")) {
            return ct.split(",")[0];
        }
        return ct;
    }

    public static enum BUFFERING {
        always,
        never,
        whenNeeded;

    }
}

