/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http.webdav;

import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.XmlWriter;
import com.bradmcevoy.http.values.ValueAndType;
import com.bradmcevoy.http.values.ValueWriters;
import com.bradmcevoy.http.webdav.PropFindResponse;
import com.bradmcevoy.http.webdav.WebDavProtocol;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropFindXmlGenerator {
    private static final Logger log = LoggerFactory.getLogger(PropFindXmlGenerator.class);
    private final Helper helper;
    private final ValueWriters valueWriters;

    public PropFindXmlGenerator(ValueWriters valueWriters) {
        this.helper = new Helper();
        this.valueWriters = valueWriters;
    }

    PropFindXmlGenerator(Helper helper, ValueWriters valueWriters) {
        this.helper = helper;
        this.valueWriters = valueWriters;
    }

    public String generate(List<PropFindResponse> propFindResponses) {
        ByteArrayOutputStream responseOutput = new ByteArrayOutputStream();
        Map<String, String> mapOfNamespaces = this.helper.findNameSpaces(propFindResponses);
        ByteArrayOutputStream generatedXml = new ByteArrayOutputStream();
        XmlWriter writer = new XmlWriter((OutputStream)generatedXml);
        writer.writeXMLHeader();
        writer.open(WebDavProtocol.NS_DAV.getPrefix(), "multistatus" + this.helper.generateNamespaceDeclarations(mapOfNamespaces));
        writer.newLine();
        this.helper.appendResponses(writer, propFindResponses, mapOfNamespaces);
        writer.close(WebDavProtocol.NS_DAV.getPrefix(), "multistatus");
        writer.flush();
        this.helper.write(generatedXml, (OutputStream)responseOutput);
        try {
            return responseOutput.toString("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    class Helper {
        Helper() {
        }

        Map<String, String> findNameSpaces(List<PropFindResponse> propFindResponses) {
            int i = 1;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(WebDavProtocol.NS_DAV.getName(), WebDavProtocol.NS_DAV.getPrefix());
            for (PropFindResponse r : propFindResponses) {
                for (QName p : r.getKnownProperties().keySet()) {
                    String uri = p.getNamespaceURI();
                    if (map.containsKey(uri)) continue;
                    map.put(uri, "ns" + i++);
                }
            }
            return map;
        }

        String generateNamespaceDeclarations(Map<String, String> mapOfNamespaces) {
            String decs = "";
            for (String uri : mapOfNamespaces.keySet()) {
                String prefix = mapOfNamespaces.get(uri);
                decs = decs + " xmlns:" + prefix + "=\"" + uri + "\"";
            }
            return decs;
        }

        void appendResponses(XmlWriter writer, List<PropFindResponse> propFindResponses, Map<String, String> mapOfNamespaces) {
            for (PropFindResponse r : propFindResponses) {
                XmlWriter.Element el = writer.begin(WebDavProtocol.NS_DAV.getPrefix(), "response");
                el.open();
                writer.writeProperty(WebDavProtocol.NS_DAV.getPrefix(), "href", r.getHref());
                this.sendKnownProperties(writer, mapOfNamespaces, r.getKnownProperties(), r.getHref());
                if (r.getErrorProperties() != null) {
                    for (Response.Status status : r.getErrorProperties().keySet()) {
                        List<PropFindResponse.NameAndError> props = r.getErrorProperties().get((Object)status);
                        this.sendErrorProperties(status, writer, mapOfNamespaces, props);
                    }
                }
                el.close();
            }
        }

        private void sendKnownProperties(XmlWriter writer, Map<String, String> mapOfNamespaces, Map<QName, ValueAndType> properties, String href) {
            this.sendProperties(Response.Status.SC_OK, writer, mapOfNamespaces, properties, href);
        }

        private void sendProperties(Response.Status status, XmlWriter writer, Map<String, String> mapOfNamespaces, Map<QName, ValueAndType> properties, String href) {
            if (!properties.isEmpty()) {
                XmlWriter.Element elPropStat = writer.begin(WebDavProtocol.NS_DAV.getPrefix(), "propstat").open();
                XmlWriter.Element elProp = writer.begin(WebDavProtocol.NS_DAV.getPrefix(), "prop").open();
                for (QName qname : properties.keySet()) {
                    String prefix = mapOfNamespaces.get(qname.getNamespaceURI());
                    ValueAndType val = properties.get(qname);
                    PropFindXmlGenerator.this.valueWriters.writeValue(writer, qname, prefix, val, href, mapOfNamespaces);
                }
                elProp.close();
                writer.writeProperty(WebDavProtocol.NS_DAV.getPrefix(), "status", status.toString());
                elPropStat.close();
            }
        }

        private void sendErrorProperties(Response.Status status, XmlWriter writer, Map<String, String> mapOfNamespaces, List<PropFindResponse.NameAndError> properties) {
            if (!properties.isEmpty()) {
                XmlWriter.Element elPropStat = writer.begin(WebDavProtocol.NS_DAV.getPrefix(), "propstat").open();
                XmlWriter.Element elProp = writer.begin(WebDavProtocol.NS_DAV.getPrefix(), "prop").open();
                for (PropFindResponse.NameAndError ne : properties) {
                    QName qname = ne.getName();
                    String prefix = mapOfNamespaces.get(qname.getNamespaceURI());
                    writer.writeProperty(prefix, qname.getLocalPart());
                }
                elProp.close();
                writer.writeProperty(WebDavProtocol.NS_DAV.getPrefix(), "status", status.toString());
                elPropStat.close();
            }
        }

        void write(ByteArrayOutputStream out, OutputStream outputStream) {
            try {
                String xml = out.toString("UTF-8");
                outputStream.write(xml.getBytes());
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

