/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.property;

import com.bradmcevoy.http.CustomProperty;
import com.bradmcevoy.http.CustomPropertyResource;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.property.PropertySource;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;

public class CustomPropertySource
implements PropertySource {
    @Override
    public Object getProperty(QName name, Resource r) {
        CustomProperty prop = this.lookupProperty(name, r);
        if (prop != null) {
            return prop.getTypedValue();
        }
        return null;
    }

    @Override
    public PropertySource.PropertyMetaData getPropertyMetaData(QName name, Resource r) {
        CustomProperty prop = this.lookupProperty(name, r);
        if (prop != null) {
            return new PropertySource.PropertyMetaData(PropertySource.PropertyAccessibility.WRITABLE, prop.getValueClass());
        }
        return PropertySource.PropertyMetaData.UNKNOWN;
    }

    @Override
    public void setProperty(QName name, Object value, Resource r) {
        CustomProperty prop = this.lookupProperty(name, r);
        if (prop == null) {
            throw new RuntimeException("property not found: " + name.getLocalPart());
        }
        prop.setFormattedValue(value.toString());
    }

    public boolean hasProperty(QName name, Resource r) {
        CustomProperty prop = this.lookupProperty(name, r);
        return prop != null;
    }

    @Override
    public void clearProperty(QName name, Resource r) {
        CustomProperty prop = this.lookupProperty(name, r);
        prop.setFormattedValue(null);
    }

    private CustomProperty lookupProperty(QName name, Resource r) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (r instanceof CustomPropertyResource) {
            CustomPropertyResource cpr = (CustomPropertyResource)r;
            if (cpr.getNameSpaceURI() == null) {
                throw new IllegalArgumentException("namespace uri is null on CPR");
            }
            if (cpr.getNameSpaceURI().equals(name.getNamespaceURI())) {
                return cpr.getProperty(name.getLocalPart());
            }
            return null;
        }
        return null;
    }

    @Override
    public List<QName> getAllPropertyNames(Resource r) {
        ArrayList<QName> list = new ArrayList<QName>();
        if (r instanceof CustomPropertyResource) {
            CustomPropertyResource cpr = (CustomPropertyResource)r;
            for (String n : cpr.getAllPropertyNames()) {
                QName qname = new QName(cpr.getNameSpaceURI(), n);
                list.add(qname);
            }
        }
        return list;
    }
}

