/*
 * Decompiled with CFR 0.152.
 */
package com.ettrema.http.fck;

import com.bradmcevoy.common.Path;
import com.bradmcevoy.http.CollectionResource;
import com.bradmcevoy.http.FileItem;
import com.bradmcevoy.http.MakeCollectionableResource;
import com.bradmcevoy.http.PutableResource;
import com.bradmcevoy.http.Range;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.exceptions.BadRequestException;
import com.bradmcevoy.http.exceptions.ConflictException;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import com.bradmcevoy.io.FileUtils;
import com.ettrema.http.fck.FckCommon;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FckQuickUploaderResource
extends FckCommon {
    private static final Logger log = LoggerFactory.getLogger(FckQuickUploaderResource.class);
    public static final String UPLOAD_RESPONSE_TEMPLATE_NORMAL = "<script type=\"text/javascript\">\nwindow.parent.frames['frmUpload'].OnUploadCompleted([code],'[name]') ;\n</script>\n";
    public static final Path URL = Path.path("/fck_upload");
    private int code;
    private String filename;

    public FckQuickUploaderResource(CollectionResource host) {
        super(host, URL);
    }

    @Override
    public String getUniqueId() {
        return "fckquickuploader";
    }

    @Override
    public String processForm(Map<String, String> params, Map<String, FileItem> files) throws BadRequestException {
        if (files == null || files.isEmpty()) {
            log.warn("no files to upload");
            return null;
        }
        for (FileItem f : files.values()) {
            this.processFileUpload(f, params);
        }
        return null;
    }

    private void processFileUpload(FileItem f, Map<String, String> params) throws BadRequestException {
        String newName;
        String name;
        block20: {
            CollectionResource target = null;
            if (this.wrappedResource == null) {
                throw new BadRequestException(this, "collection not found");
            }
            target = (CollectionResource)this.wrappedResource.child("uploads");
            if (target == null) {
                try {
                    if (!(this.wrappedResource instanceof MakeCollectionableResource)) {
                        throw new BadRequestException(target, "Cant create subfolder");
                    }
                    MakeCollectionableResource mk = (MakeCollectionableResource)this.wrappedResource;
                    target = mk.createCollection("uploads");
                }
                catch (ConflictException ex) {
                    throw new RuntimeException(ex);
                }
                catch (NotAuthorizedException ex) {
                    throw new RuntimeException(ex);
                }
                catch (BadRequestException ex) {
                    throw new RuntimeException(ex);
                }
            }
            name = FileUtils.sanitiseName(f.getName());
            log.debug("processFileUpload: " + name);
            boolean isFirst = true;
            newName = null;
            while (target.child(name) != null) {
                newName = name = FileUtils.incrementFileName(name, isFirst);
                isFirst = false;
            }
            long size = f.getSize();
            try {
                if (target instanceof PutableResource) {
                    PutableResource putable = (PutableResource)target;
                    Resource newRes = putable.createNew(name, f.getInputStream(), size, null);
                    if (newRes != null) {
                        log.trace("created: " + newRes.getName() + " of type: " + newRes.getClass());
                    } else {
                        log.trace("createNew returned null");
                    }
                    break block20;
                }
                throw new BadRequestException(target, "Does not implement PutableResource");
            }
            catch (ConflictException ex) {
                throw new RuntimeException(ex);
            }
            catch (NotAuthorizedException ex) {
                throw new RuntimeException(ex);
            }
            catch (BadRequestException ex) {
                throw new RuntimeException(ex);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        try {
            if (newName != null) {
                this.uploadResponseOk(name);
            } else {
                this.uploadResponseOk();
            }
        }
        catch (Throwable ex) {
            log.error("Exception saving new file", ex);
            this.uploadResponseFailed(ex.getMessage());
        }
    }

    private void uploadResponseOk() {
        this.uploadResponse(0, null);
    }

    private void uploadResponseOk(String newName) {
        this.uploadResponse(201, newName);
    }

    private void uploadResponseFailed(String reason) {
        this.uploadResponse(1, reason);
    }

    private void uploadResponse(int code, String filename) {
        this.code = code;
        this.filename = filename;
    }

    @Override
    public void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException {
        String s = UPLOAD_RESPONSE_TEMPLATE_NORMAL;
        s = s.replace("[code]", this.code + "");
        String f = this.filename == null ? "" : this.filename;
        s = s.replace("[name]", f);
        out.write(s.getBytes());
    }

    @Override
    public String getContentType(String accepts) {
        return "text/html";
    }
}

