package com.fasterxml.jackson.module.jsonSchema.jakarta.factories;

import java.util.Set;

import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import com.fasterxml.jackson.module.jsonSchema.jakarta.types.StringSchema;

public class StringVisitor extends JsonStringFormatVisitor.Base
    implements JsonSchemaProducer
{
    protected final StringSchema schema;
	
    public StringVisitor(StringSchema schema) {
        this.schema = schema;
    }

    /*
    /*********************************************************************
    /* JsonSchemaProducer
    /*********************************************************************
     */
	
    @Override
    public void enumTypes(Set<String> enums) {
        schema.setEnums(enums);
    }

    @Override
    public void format(JsonValueFormat format) {
        schema.setFormat(format);
    }

    @Override
    public StringSchema getSchema() {
        return schema;
    }
}
