/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.jsonSchema.jakarta.factories;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonMapFormatVisitor;
import com.fasterxml.jackson.module.jsonSchema.jakarta.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.jakarta.factories.JsonSchemaProducer;
import com.fasterxml.jackson.module.jsonSchema.jakarta.factories.SchemaFactoryWrapper;
import com.fasterxml.jackson.module.jsonSchema.jakarta.factories.Visitor;
import com.fasterxml.jackson.module.jsonSchema.jakarta.factories.VisitorContext;
import com.fasterxml.jackson.module.jsonSchema.jakarta.factories.WrapperFactory;
import com.fasterxml.jackson.module.jsonSchema.jakarta.types.ObjectSchema;
import com.fasterxml.jackson.module.jsonSchema.jakarta.types.ReferenceSchema;

public class MapVisitor
extends JsonMapFormatVisitor.Base
implements JsonSchemaProducer,
Visitor {
    protected final ObjectSchema schema;
    protected SerializerProvider provider;
    private WrapperFactory wrapperFactory;
    private VisitorContext visitorContext;

    public MapVisitor(SerializerProvider provider, ObjectSchema schema) {
        this(provider, schema, new WrapperFactory());
    }

    public MapVisitor(SerializerProvider provider, ObjectSchema schema, WrapperFactory wrapperFactory) {
        this.provider = provider;
        this.schema = schema;
        this.wrapperFactory = wrapperFactory;
    }

    @Override
    public ObjectSchema getSchema() {
        return this.schema;
    }

    public SerializerProvider getProvider() {
        return this.provider;
    }

    public void setProvider(SerializerProvider p) {
        this.provider = p;
    }

    public void keyFormat(JsonFormatVisitable handler, JavaType keyType) throws JsonMappingException {
    }

    public void valueFormat(JsonFormatVisitable handler, JavaType valueType) throws JsonMappingException {
        JsonSchema valueSchema = this.propertySchema(handler, valueType);
        ObjectSchema.SchemaAdditionalProperties ap = new ObjectSchema.SchemaAdditionalProperties(valueSchema.asSimpleTypeSchema());
        this.schema.setAdditionalProperties(ap);
    }

    protected JsonSchema propertySchema(JsonFormatVisitable handler, JavaType propertyTypeHint) throws JsonMappingException {
        String seenSchemaUri;
        if (this.visitorContext != null && (seenSchemaUri = this.visitorContext.getSeenSchemaUri(propertyTypeHint)) != null) {
            return new ReferenceSchema(seenSchemaUri);
        }
        SchemaFactoryWrapper visitor = this.wrapperFactory.getWrapper(this.getProvider(), this.visitorContext);
        handler.acceptJsonFormatVisitor((JsonFormatVisitorWrapper)visitor, propertyTypeHint);
        return visitor.finalSchema();
    }

    @Override
    public Visitor setVisitorContext(VisitorContext rvc) {
        this.visitorContext = rvc;
        return this;
    }
}

