/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.MovieTag;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import java.io.IOException;

public final class LimitScript
implements MovieTag {
    private static final int MAX_DEPTH = 65535;
    private static final int MAX_TIMEOUT = 65535;
    private static final String FORMAT = "LimitScript: { depth=%d; timeout=%d}";
    private int depth;
    private int timeout;

    public LimitScript(SWFDecoder coder) throws IOException {
        int length = coder.readUnsignedShort() & 0x3F;
        if (length == 63) {
            length = coder.readInt();
        }
        this.depth = coder.readUnsignedShort();
        this.timeout = coder.readUnsignedShort();
    }

    public LimitScript(int stackDepth, int timeLimit) {
        this.setDepth(stackDepth);
        this.setTimeout(timeLimit);
    }

    public LimitScript(LimitScript object) {
        this.depth = object.depth;
        this.timeout = object.timeout;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int stackDepth) {
        if (stackDepth < 0 || stackDepth > 65535) {
            throw new IllegalArgumentRangeException(0, 65535, stackDepth);
        }
        this.depth = stackDepth;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int time) {
        if (time < 0 || time > 65535) {
            throw new IllegalArgumentRangeException(0, 65535, time);
        }
        this.timeout = time;
    }

    @Override
    public LimitScript copy() {
        return new LimitScript(this);
    }

    public String toString() {
        return String.format(FORMAT, this.depth, this.timeout);
    }

    @Override
    public int prepareToEncode(Context context) {
        return 6;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeShort(4164);
        coder.writeShort(this.depth);
        coder.writeShort(this.timeout);
    }
}

