/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.MovieTag;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import java.io.IOException;

public final class TabOrder
implements MovieTag {
    public static final int MAX_TAB = 65535;
    private static final String FORMAT = "TabOrder: { layer=%d; index=%d}";
    private int layer;
    private int index;

    public TabOrder(SWFDecoder coder) throws IOException {
        int length = coder.readUnsignedShort() & 0x3F;
        if (length == 63) {
            length = coder.readInt();
        }
        this.layer = coder.readUnsignedShort();
        this.index = coder.readUnsignedShort();
    }

    public TabOrder(int level, int idx) {
        this.setLayer(level);
        this.setIndex(idx);
    }

    public TabOrder(TabOrder object) {
        this.layer = object.layer;
        this.index = object.index;
    }

    public int getLayer() {
        return this.layer;
    }

    public void setLayer(int level) {
        if (level < 1 || level > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, level);
        }
        this.layer = level;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int idx) {
        if (idx < 0 || idx > 65535) {
            throw new IllegalArgumentRangeException(0, 65535, idx);
        }
        this.index = idx;
    }

    @Override
    public TabOrder copy() {
        return new TabOrder(this);
    }

    public String toString() {
        return String.format(FORMAT, this.layer, this.index);
    }

    @Override
    public int prepareToEncode(Context context) {
        return 6;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeShort(4228);
        coder.writeShort(this.layer);
        coder.writeShort(this.index);
    }
}

