/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.action;

import com.flagstone.transform.action.Action;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFEncoder;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public enum BasicAction implements Action
{
    END(0),
    NEXT_FRAME(4),
    PREV_FRAME(5),
    PLAY(6),
    STOP(7),
    TOGGLE_QUALITY(8),
    STOP_SOUNDS(9),
    INTEGER_ADD(10),
    SUBTRACT(11),
    MULTIPLY(12),
    DIVIDE(13),
    INTEGER_EQUALS(14),
    INTEGER_LESS(15),
    LOGICAL_AND(16),
    LOGICAL_NOT(18),
    LOGICAL_OR(17),
    STRING_EQUALS(19),
    STRING_LENGTH(20),
    STRING_EXTRACT(21),
    POP(23),
    TO_INTEGER(24),
    GET_VARIABLE(28),
    SET_VARIABLE(29),
    SET_TARGET_2(32),
    STRING_ADD(33),
    GET_PROPERTY(34),
    SET_PROPERTY(35),
    CLONE_SPRITE(36),
    REMOVE_SPRITE(37),
    TRACE(38),
    START_DRAG(39),
    END_DRAG(40),
    STRING_LESS(41),
    THROW(42),
    CAST(43),
    IMPLEMENTS(44),
    FS_COMMAND2(45),
    RANDOM_NUMBER(48),
    MB_STRING_LENGTH(49),
    CHAR_TO_ASCII(50),
    ASCII_TO_CHAR(51),
    GET_TIME(52),
    MB_STRING_EXTRACT(53),
    MB_CHAR_TO_ASCII(54),
    MB_ASCII_TO_CHAR(55),
    DELETE_VARIABLE(58),
    DELETE(59),
    INIT_VARIABLE(60),
    EXECUTE_FUNCTION(61),
    RETURN(62),
    MODULO(63),
    NAMED_OBJECT(64),
    NEW_VARIABLE(65),
    NEW_ARRAY(66),
    NEW_OBJECT(67),
    GET_TYPE(68),
    GET_TARGET(69),
    ENUMERATE(70),
    ADD(71),
    LESS(72),
    EQUALS(73),
    TO_NUMBER(74),
    TO_STRING(75),
    DUPLICATE(76),
    SWAP(77),
    GET_ATTRIBUTE(78),
    SET_ATTRIBUTE(79),
    INCREMENT(80),
    DECREMENT(81),
    EXECUTE_METHOD(82),
    NEW_METHOD(83),
    INSTANCEOF(84),
    ENUMERATE_OBJECT(85),
    BITWISE_AND(96),
    BITWISE_OR(97),
    BITWISE_XOR(98),
    SHIFT_LEFT(99),
    ARITH_SHIFT_RIGHT(100),
    SHIFT_RIGHT(101),
    STRICT_EQUALS(102),
    GREATER(103),
    STRING_GREATER(104),
    EXTENDS(105);

    private static final Map<Integer, BasicAction> TABLE;
    private final int type;

    public static BasicAction fromInt(int actionType) {
        return TABLE.get(actionType);
    }

    private BasicAction(int actionType) {
        this.type = actionType;
    }

    @Override
    public BasicAction copy() {
        return this;
    }

    @Override
    public int prepareToEncode(Context context) {
        return 1;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeByte(this.type);
    }

    static {
        TABLE = new LinkedHashMap<Integer, BasicAction>();
        for (BasicAction action : BasicAction.values()) {
            TABLE.put(action.type, action);
        }
    }
}

