/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.fillstyle;

import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.datatype.Color;
import com.flagstone.transform.fillstyle.FillStyle;
import java.io.IOException;

public final class SolidFill
implements FillStyle {
    private static final String FORMAT = "SolidFill: { color=%s}";
    private Color color;

    public SolidFill(SWFDecoder coder, Context context) throws IOException {
        this.color = new Color(coder, context);
    }

    public SolidFill(Color aColor) {
        this.setColor(aColor);
    }

    public SolidFill(SolidFill object) {
        this.color = object.color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color aColor) {
        if (aColor == null) {
            throw new IllegalArgumentException();
        }
        this.color = aColor;
    }

    @Override
    public SolidFill copy() {
        return new SolidFill(this);
    }

    public String toString() {
        return String.format(FORMAT, this.color.toString());
    }

    @Override
    public int prepareToEncode(Context context) {
        return 1 + this.color.prepareToEncode(context);
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeByte(0);
        this.color.encode(coder, context);
    }
}

