/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.filter;

import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.datatype.Color;
import com.flagstone.transform.fillstyle.Gradient;
import com.flagstone.transform.filter.Filter;
import com.flagstone.transform.filter.FilterMode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class GradientBevelFilter
implements Filter {
    private static final int MODE_MASK = 208;
    private static final String FORMAT = "GradientBevelFilter: { gradients=%s; blurX=%f; blurY=%f; angle=%f; distance=%f; strength=%f; mode=%s; passes=%d}";
    private final transient List<Gradient> gradients;
    private final transient int blurX;
    private final transient int blurY;
    private final transient int angle;
    private final transient int distance;
    private final transient int strength;
    private final transient int mode;
    private final transient int passes;

    public GradientBevelFilter(Builder builder) {
        this.gradients = builder.gradients;
        this.blurX = builder.blurX;
        this.blurY = builder.blurY;
        this.angle = builder.angle;
        this.distance = builder.distance;
        this.strength = builder.strength;
        this.mode = builder.mode;
        this.passes = builder.passes;
    }

    public GradientBevelFilter(SWFDecoder coder, Context context) throws IOException {
        int i;
        int count = coder.readByte();
        Color[] colors = new Color[count];
        int[] ratioes = new int[count];
        for (i = 0; i < count; ++i) {
            colors[i] = new Color(coder, context);
        }
        for (i = 0; i < count; ++i) {
            ratioes[i] = coder.readByte();
        }
        this.gradients = new ArrayList<Gradient>(count);
        for (i = 0; i < count; ++i) {
            this.gradients.add(new Gradient(ratioes[i], colors[i]));
        }
        this.blurX = coder.readInt();
        this.blurY = coder.readInt();
        this.angle = coder.readInt();
        this.distance = coder.readInt();
        this.strength = coder.readSignedShort();
        int value = coder.readByte();
        this.passes = value & 0xF;
        this.mode = value & 0xD0;
    }

    public List<Gradient> getGradients() {
        return this.gradients;
    }

    public float getBlurX() {
        return (float)this.blurX / 65536.0f;
    }

    public float getBlurY() {
        return (float)this.blurY / 65536.0f;
    }

    public float getAngle() {
        return (float)this.angle / 65536.0f;
    }

    public float getDistance() {
        return (float)this.distance / 65536.0f;
    }

    public float getStrength() {
        return (float)this.strength / 256.0f;
    }

    public FilterMode getMode() {
        FilterMode value;
        switch (this.mode) {
            case 16: {
                value = FilterMode.TOP;
                break;
            }
            case 64: {
                value = FilterMode.KNOCKOUT;
                break;
            }
            case 128: {
                value = FilterMode.INNER;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return value;
    }

    public int getPasses() {
        return this.passes;
    }

    public String toString() {
        return String.format(FORMAT, this.gradients.toString(), Float.valueOf(this.getBlurX()), Float.valueOf(this.getBlurY()), Float.valueOf(this.getAngle()), Float.valueOf(this.getDistance()), Float.valueOf(this.getStrength()), this.mode, this.passes);
    }

    public boolean equals(Object object) {
        boolean result;
        if (object == null) {
            result = false;
        } else if (object == this) {
            result = true;
        } else if (object instanceof GradientBevelFilter) {
            GradientBevelFilter filter = (GradientBevelFilter)object;
            result = ((Object)this.gradients).equals(filter.gradients) && this.blurX == filter.blurX && this.blurY == filter.blurY && this.angle == filter.angle && this.distance == filter.distance && this.strength == filter.strength && this.mode == filter.mode && this.passes == filter.passes;
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        return ((((((((Object)this.gradients).hashCode() * 31 + this.blurX) * 31 + this.blurY) * 31 + this.angle) * 31 + this.distance) * 31 + this.strength) * 31 + this.mode) * 31 + this.passes;
    }

    @Override
    public int prepareToEncode(Context context) {
        return 21 + 5 * this.gradients.size();
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeByte(7);
        coder.writeByte(this.gradients.size());
        for (Gradient gradient : this.gradients) {
            gradient.getColor().encode(coder, context);
        }
        for (Gradient gradient : this.gradients) {
            coder.writeByte(gradient.getRatio());
        }
        coder.writeInt(this.blurX);
        coder.writeInt(this.blurY);
        coder.writeInt(this.angle);
        coder.writeInt(this.distance);
        coder.writeShort(this.strength);
        coder.writeByte(0x20 | this.mode | this.passes);
    }

    public static final class Builder {
        private final transient List<Gradient> gradients = new ArrayList<Gradient>();
        private transient int blurX;
        private transient int blurY;
        private transient int angle;
        private transient int distance;
        private transient int strength;
        private transient int mode;
        private transient int passes;

        public Builder addGradient(Gradient gradient) {
            this.gradients.add(gradient);
            return this;
        }

        public Builder setBlur(float xAmount, float yAmount) {
            this.blurX = (int)(xAmount * 65536.0f);
            this.blurY = (int)(yAmount * 65536.0f);
            return this;
        }

        public Builder setMode(FilterMode filterMode) {
            switch (filterMode) {
                case TOP: {
                    this.mode = 16;
                    break;
                }
                case KNOCKOUT: {
                    this.mode = 64;
                    break;
                }
                case INNER: {
                    this.mode = 128;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            return this;
        }

        public Builder setAngle(float radians) {
            this.angle = (int)(radians * 65536.0f);
            return this;
        }

        public Builder setDistance(float width) {
            this.distance = (int)(width * 65536.0f);
            return this;
        }

        public Builder setStrength(float weight) {
            this.strength = (int)(weight * 256.0f);
            return this;
        }

        public Builder setPasses(int count) {
            this.passes = count;
            return this;
        }

        public GradientBevelFilter build() {
            return new GradientBevelFilter(this);
        }
    }
}

