/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.font;

import com.flagstone.transform.DefineTag;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import java.io.IOException;
import java.util.Arrays;

public final class DefineFont4
implements DefineTag {
    private static final String FORMAT = "DefineFont4: { identifier=%d; italic=%d; bold=%d; name=%s; data=byte<%d> ...}";
    private int identifier;
    private boolean italic;
    private boolean bold;
    private String name;
    private byte[] data;
    private transient int length;

    public DefineFont4(SWFDecoder coder) throws IOException {
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        this.identifier = coder.readUnsignedShort();
        int bits = coder.readByte();
        this.italic = (bits & 2) == 1;
        this.bold = (bits & 2) == 1;
        this.name = coder.readString();
        this.data = coder.readBytes(new byte[this.length - coder.bytesRead()]);
        coder.check(this.length);
        coder.unmark();
    }

    public DefineFont4(int uid, String fontName, boolean isItalic, boolean isBold, byte[] font) {
        this.setIdentifier(uid);
        this.setItalic(isItalic);
        this.setBold(isBold);
        this.setName(fontName);
        this.setData(font);
    }

    public DefineFont4(DefineFont4 object) {
        this.identifier = object.identifier;
        this.italic = object.italic;
        this.bold = object.bold;
        this.name = object.name;
        this.data = object.data;
    }

    @Override
    public int getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(int uid) {
        if (uid < 1 || uid > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, uid);
        }
        this.identifier = uid;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public boolean isBold() {
        return this.bold;
    }

    public String getName() {
        return this.name;
    }

    public void setItalic(boolean aBool) {
        this.italic = aBool;
    }

    public void setBold(boolean aBool) {
        this.bold = aBool;
    }

    public void setName(String aString) {
        if (aString == null) {
            throw new IllegalArgumentException();
        }
        this.name = aString;
    }

    public byte[] getData() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    public void setData(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException();
        }
        this.data = Arrays.copyOf(bytes, bytes.length);
    }

    @Override
    public DefineFont4 copy() {
        return new DefineFont4(this);
    }

    public String toString() {
        return String.format(FORMAT, this.identifier, this.italic, this.bold, this.name, this.data.length);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = 3 + context.strlen(this.name) + this.data.length;
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(5887);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0x16C0 | this.length);
        }
        coder.mark();
        coder.writeShort(this.identifier);
        int bits = 0;
        bits |= this.data.length > 0 ? 4 : 0;
        bits |= this.italic ? 2 : 0;
        coder.writeByte(bits |= this.bold ? 1 : 0);
        coder.writeString(this.name);
        coder.writeBytes(this.data);
        coder.check(this.length);
        coder.unmark();
    }
}

