/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.image;

import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import com.flagstone.transform.image.ImageTag;
import java.io.IOException;
import java.util.Arrays;

public final class DefineImage
implements ImageTag {
    private static final String FORMAT = "DefineImage: { identifier=%d; pixelSize=%d; width=%d; height=%d; tableSize=%d; image=byte<%d> ...}";
    private static final int IDX_FORMAT = 3;
    private static final int RGB5_FORMAT = 4;
    private static final int RGB8_FORMAT = 5;
    private static final int IDX_SIZE = 8;
    private static final int RGB5_SIZE = 16;
    private static final int RGB8_SIZE = 24;
    private static final int TABLE_SIZE = 256;
    private int identifier;
    private int width;
    private int height;
    private int pixelSize;
    private int tableSize;
    private byte[] image;
    private transient int length;

    public DefineImage(SWFDecoder coder) throws IOException {
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        this.identifier = coder.readUnsignedShort();
        switch (coder.readByte()) {
            case 3: {
                this.pixelSize = 8;
                break;
            }
            case 4: {
                this.pixelSize = 16;
                break;
            }
            case 5: {
                this.pixelSize = 24;
                break;
            }
            default: {
                this.pixelSize = 0;
            }
        }
        this.width = coder.readUnsignedShort();
        this.height = coder.readUnsignedShort();
        if (this.pixelSize == 8) {
            this.tableSize = coder.readByte() + 1;
            this.image = coder.readBytes(new byte[this.length - 8]);
        } else {
            this.image = coder.readBytes(new byte[this.length - 7]);
        }
        coder.check(this.length);
        coder.unmark();
    }

    public DefineImage(int uid, int imgWidth, int imgHeight, int size, byte[] data) {
        this.setIdentifier(uid);
        this.setWidth(imgWidth);
        this.setHeight(imgHeight);
        this.setPixelSize(8);
        this.setTableSize(size);
        this.setImage(data);
    }

    public DefineImage(int uid, int imgWidth, int imgHeight, byte[] data, int size) {
        this.setIdentifier(uid);
        this.setWidth(imgWidth);
        this.setHeight(imgHeight);
        this.setPixelSize(size);
        this.tableSize = 0;
        this.setImage(data);
    }

    public DefineImage(DefineImage object) {
        this.identifier = object.identifier;
        this.width = object.width;
        this.height = object.height;
        this.pixelSize = object.pixelSize;
        this.tableSize = object.tableSize;
        this.image = object.image;
    }

    @Override
    public int getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(int uid) {
        if (uid < 1 || uid > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, uid);
        }
        this.identifier = uid;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public int getPixelSize() {
        return this.pixelSize;
    }

    public int getTableSize() {
        return this.tableSize;
    }

    public byte[] getImage() {
        return Arrays.copyOf(this.image, this.image.length);
    }

    public void setWidth(int aNumber) {
        if (aNumber < 0 || aNumber > 65535) {
            throw new IllegalArgumentRangeException(0, 65535, aNumber);
        }
        this.width = aNumber;
    }

    public void setHeight(int aNumber) {
        if (aNumber < 0 || aNumber > 65535) {
            throw new IllegalArgumentRangeException(0, 65535, aNumber);
        }
        this.height = aNumber;
    }

    public void setPixelSize(int size) {
        if (size != 8 && size != 16 && size != 24) {
            throw new IllegalArgumentException("Pixel size must be either 8, 16 or 24.");
        }
        this.pixelSize = size;
    }

    public void setTableSize(int size) {
        if (size < 1 || size > 256) {
            throw new IllegalArgumentException("Colour table size must be in the range 1..256.");
        }
        this.tableSize = size;
    }

    public void setImage(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException();
        }
        this.image = Arrays.copyOf(bytes, bytes.length);
    }

    @Override
    public DefineImage copy() {
        return new DefineImage(this);
    }

    public String toString() {
        return String.format(FORMAT, this.identifier, this.pixelSize, this.width, this.height, this.tableSize, this.image.length);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = 7;
        this.length += this.pixelSize == 8 ? 1 : 0;
        this.length += this.image.length;
        return 6 + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeShort(1343);
        coder.writeInt(this.length);
        coder.mark();
        coder.writeShort(this.identifier);
        switch (this.pixelSize) {
            case 8: {
                coder.writeByte(3);
                break;
            }
            case 16: {
                coder.writeByte(4);
                break;
            }
            case 24: {
                coder.writeByte(5);
                break;
            }
        }
        coder.writeShort(this.width);
        coder.writeShort(this.height);
        if (this.pixelSize == 8) {
            coder.writeByte(this.tableSize - 1);
        }
        coder.writeBytes(this.image);
        coder.check(this.length);
        coder.unmark();
    }
}

