/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.linestyle;

import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.datatype.Color;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import com.flagstone.transform.linestyle.LineStyle;
import java.io.IOException;

public final class LineStyle1
implements LineStyle {
    private static final String FORMAT = "LineStyle : { width=%d; color=%s}";
    private int width;
    private Color color;

    public LineStyle1(SWFDecoder coder, Context context) throws IOException {
        this.width = coder.readUnsignedShort();
        this.color = new Color(coder, context);
    }

    public LineStyle1(int aWidth, Color aColor) {
        this.setWidth(aWidth);
        this.setColor(aColor);
    }

    public LineStyle1(LineStyle1 object) {
        this.width = object.width;
        this.color = object.color;
    }

    public int getWidth() {
        return this.width;
    }

    public Color getColor() {
        return this.color;
    }

    public void setWidth(int aNumber) {
        if (aNumber < 0 || aNumber > 65535) {
            throw new IllegalArgumentRangeException(0, 65535, aNumber);
        }
        this.width = aNumber;
    }

    public void setColor(Color aColor) {
        if (aColor == null) {
            throw new IllegalArgumentException();
        }
        this.color = aColor;
    }

    @Override
    public LineStyle1 copy() {
        return new LineStyle1(this);
    }

    public String toString() {
        return String.format(FORMAT, this.width, this.color);
    }

    @Override
    public int prepareToEncode(Context context) {
        return 2 + (context.contains(3) ? 4 : 3);
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeShort(this.width);
        this.color.encode(coder, context);
    }
}

