/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.shape;

import com.flagstone.transform.coder.Coder;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import com.flagstone.transform.shape.ShapeRecord;
import java.io.IOException;

public final class Curve
implements ShapeRecord {
    private static final String FORMAT = "Curve: (%d, %d) (%d, %d)";
    private static final int SIZE_WIDTH = 4;
    private transient int controlX;
    private transient int controlY;
    private transient int anchorX;
    private transient int anchorY;
    private transient int size;

    public Curve(SWFDecoder coder) throws IOException {
        this.size = coder.readBits(4, false) + 2;
        this.controlX = coder.readBits(this.size, true);
        this.controlY = coder.readBits(this.size, true);
        this.anchorX = coder.readBits(this.size, true);
        this.anchorY = coder.readBits(this.size, true);
    }

    public Curve(int xControl, int yControl, int xAnchor, int yAnchor) {
        this.setPoints(xControl, yControl, xAnchor, yAnchor);
    }

    public Curve(Curve object) {
        this.controlX = object.controlX;
        this.controlY = object.controlY;
        this.anchorX = object.anchorX;
        this.anchorY = object.anchorY;
    }

    public int getControlX() {
        return this.controlX;
    }

    public int getControlY() {
        return this.controlY;
    }

    public int getAnchorX() {
        return this.anchorX;
    }

    public int getAnchorY() {
        return this.anchorY;
    }

    public void setPoints(int xControl, int yControl, int xAnchor, int yAnchor) {
        if (xControl < -65536 || xControl > 65535) {
            throw new IllegalArgumentRangeException(-65536, 65535, xControl);
        }
        this.controlX = xControl;
        if (yControl < -65536 || yControl > 65535) {
            throw new IllegalArgumentRangeException(-65536, 65535, yControl);
        }
        this.controlY = yControl;
        if (xAnchor < -65536 || xAnchor > 65535) {
            throw new IllegalArgumentRangeException(-65536, 65535, xAnchor);
        }
        this.anchorX = xAnchor;
        if (yAnchor < -65536 || yAnchor > 65535) {
            throw new IllegalArgumentRangeException(-65536, 65535, yAnchor);
        }
        this.anchorY = yAnchor;
    }

    @Override
    public Curve copy() {
        return new Curve(this);
    }

    public String toString() {
        return String.format(FORMAT, this.controlX, this.controlY, this.anchorX, this.anchorY);
    }

    @Override
    public int prepareToEncode(Context context) {
        int numberOfBits = 6;
        this.size = Coder.maxSize(this.controlX, this.controlY, this.anchorX, this.anchorY, 1);
        context.put(15, context.get(15) + (numberOfBits += this.size << 2));
        return numberOfBits;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeBits(2, 2);
        coder.writeBits(this.size - 2, 4);
        coder.writeBits(this.controlX, this.size);
        coder.writeBits(this.controlY, this.size);
        coder.writeBits(this.anchorX, this.size);
        coder.writeBits(this.anchorY, this.size);
    }
}

