/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.sound;

import com.flagstone.transform.MovieTag;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.sound.SoundInfo;
import java.io.IOException;

public final class StartSound2
implements MovieTag {
    private static final String FORMAT = "StartSound2: { sound=%s}";
    private String soundClass;
    private SoundInfo sound;
    private transient int length;

    public StartSound2(SWFDecoder coder) throws IOException {
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        this.soundClass = coder.readString();
        this.sound = new SoundInfo(coder.readUnsignedShort(), coder);
        coder.check(this.length);
        coder.unmark();
    }

    public StartSound2(SoundInfo aSound) {
        this.setSound(aSound);
    }

    public StartSound2(StartSound2 object) {
        this.soundClass = object.soundClass;
        this.sound = object.sound.copy();
    }

    public String getSoundClass() {
        return this.soundClass;
    }

    public SoundInfo getSound() {
        return this.sound;
    }

    public void setSoundClass(String className) {
        this.soundClass = className;
    }

    public void setSound(SoundInfo aSound) {
        if (aSound == null) {
            throw new IllegalArgumentException();
        }
        this.sound = aSound;
    }

    @Override
    public StartSound2 copy() {
        return new StartSound2(this);
    }

    public String toString() {
        return String.format(FORMAT, this.sound);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = this.soundClass.length() + this.sound.prepareToEncode(context);
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(5759);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0x1640 | this.length);
        }
        coder.mark();
        coder.writeString(this.soundClass);
        this.sound.encode(coder, context);
        coder.check(this.length);
        coder.unmark();
    }
}

