/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.text;

import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.datatype.Bounds;
import com.flagstone.transform.datatype.CoordTransform;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import com.flagstone.transform.text.StaticTextTag;
import com.flagstone.transform.text.TextSpan;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class DefineText2
implements StaticTextTag {
    private static final String FORMAT = "DefineText2: { identifier=%d; bounds=%s; transform=%s; objects=%s}";
    private int identifier;
    private Bounds bounds;
    private CoordTransform transform;
    private List<TextSpan> spans;
    private transient int length;
    private transient int glyphBits;
    private transient int advanceBits;

    public DefineText2(SWFDecoder coder, Context context) throws IOException {
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        this.identifier = coder.readUnsignedShort();
        this.bounds = new Bounds(coder);
        coder.fill();
        coder.mark();
        int sum = 0;
        for (int i = 0; i < 16; ++i) {
            sum += coder.readByte();
        }
        if (sum != 0) {
            coder.reset();
        }
        coder.unmark();
        this.transform = new CoordTransform(coder);
        this.glyphBits = coder.readByte();
        this.advanceBits = coder.readByte();
        context.put(3, 1);
        context.put(14, this.glyphBits);
        context.put(13, this.advanceBits);
        this.spans = new ArrayList<TextSpan>();
        while (coder.scanByte() != 0) {
            this.spans.add(new TextSpan(coder, context));
        }
        coder.readByte();
        context.remove(3);
        context.put(14, 0);
        context.put(13, 0);
        coder.check(this.length);
        coder.unmark();
    }

    public DefineText2(int uid, Bounds rect, CoordTransform matrix, List<TextSpan> list) {
        this.setIdentifier(uid);
        this.setBounds(rect);
        this.setTransform(matrix);
        this.setSpans(list);
    }

    public DefineText2(DefineText2 object) {
        this.identifier = object.identifier;
        this.bounds = object.bounds;
        this.transform = object.transform;
        this.spans = new ArrayList<TextSpan>(object.spans.size());
        for (TextSpan span : object.spans) {
            this.spans.add(span.copy());
        }
    }

    @Override
    public int getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(int uid) {
        if (uid < 1 || uid > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, uid);
        }
        this.identifier = uid;
    }

    public DefineText2 add(TextSpan obj) {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        this.spans.add(obj);
        return this;
    }

    @Override
    public Bounds getBounds() {
        return this.bounds;
    }

    @Override
    public CoordTransform getTransform() {
        return this.transform;
    }

    @Override
    public List<TextSpan> getSpans() {
        return this.spans;
    }

    @Override
    public void setBounds(Bounds rect) {
        if (rect == null) {
            throw new IllegalArgumentException();
        }
        this.bounds = rect;
    }

    @Override
    public void setTransform(CoordTransform matrix) {
        if (matrix == null) {
            throw new IllegalArgumentException();
        }
        this.transform = matrix;
    }

    @Override
    public void setSpans(List<TextSpan> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.spans = list;
    }

    @Override
    public DefineText2 copy() {
        return new DefineText2(this);
    }

    public String toString() {
        return String.format(FORMAT, this.identifier, this.bounds, this.transform, this.spans);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.glyphBits = this.calculateSizeForGlyphs();
        this.advanceBits = this.calculateSizeForAdvances();
        context.put(3, 1);
        context.put(14, this.glyphBits);
        context.put(13, this.advanceBits);
        this.length = 2 + this.bounds.prepareToEncode(context);
        this.length += this.transform.prepareToEncode(context);
        this.length += 2;
        for (TextSpan span : this.spans) {
            this.length += span.prepareToEncode(context);
        }
        ++this.length;
        context.remove(3);
        context.put(14, 0);
        context.put(13, 0);
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(2175);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0x840 | this.length);
        }
        coder.mark();
        coder.writeShort(this.identifier);
        context.put(3, 1);
        context.put(14, this.glyphBits);
        context.put(13, this.advanceBits);
        this.bounds.encode(coder, context);
        this.transform.encode(coder, context);
        coder.writeByte(this.glyphBits);
        coder.writeByte(this.advanceBits);
        for (TextSpan span : this.spans) {
            span.encode(coder, context);
        }
        coder.writeByte(0);
        context.remove(3);
        context.put(14, 0);
        context.put(13, 0);
        coder.check(this.length);
        coder.unmark();
    }

    private int calculateSizeForGlyphs() {
        int total = 0;
        for (TextSpan span : this.spans) {
            int size = span.glyphBits();
            if (size <= total) continue;
            total = size;
        }
        return total;
    }

    private int calculateSizeForAdvances() {
        int total = 0;
        for (TextSpan span : this.spans) {
            int size = span.advanceBits();
            if (size <= total) continue;
            total = size;
        }
        return total;
    }
}

