/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.text;

import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncodeable;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.datatype.Bounds;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import java.io.IOException;

public final class GlyphIndex
implements SWFEncodeable {
    private static final String FORMAT = "GlyphIndex: { glyphIndex=%d; advance=%d}";
    private final transient int index;
    private final transient int advance;

    public GlyphIndex(SWFDecoder coder, Context context) throws IOException {
        this.index = coder.readBits(context.get(14), false);
        this.advance = coder.readBits(context.get(13), true);
    }

    public GlyphIndex(int anIndex, int anAdvance) {
        if (anIndex < 0 || anIndex > 65535) {
            throw new IllegalArgumentRangeException(0, 65535, anIndex);
        }
        if (anAdvance < Short.MIN_VALUE || anAdvance > Short.MAX_VALUE) {
            throw new IllegalArgumentRangeException(Short.MIN_VALUE, Short.MAX_VALUE, anAdvance);
        }
        this.index = anIndex;
        this.advance = anAdvance;
    }

    public int getGlyphIndex() {
        return this.index;
    }

    public int getAdvance() {
        return this.advance;
    }

    public String toString() {
        return String.format(FORMAT, this.index, this.advance);
    }

    public boolean equals(Object other) {
        boolean result;
        if (other == null) {
            result = false;
        } else if (other == this) {
            result = true;
        } else if (other instanceof Bounds) {
            GlyphIndex object = (GlyphIndex)other;
            result = this.index == object.index && this.advance == object.advance;
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        return this.index * 31 + this.advance;
    }

    @Override
    public int prepareToEncode(Context context) {
        return context.get(14) + context.get(13);
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeBits(this.index, context.get(14));
        coder.writeBits(this.advance, context.get(13));
    }
}

