/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.util.font;

public final class FontFace {
    private final transient String name;
    private final transient boolean bold;
    private final transient boolean italic;

    public FontFace(String fontName, boolean isBold, boolean isItalic) {
        this.name = fontName;
        this.bold = isBold;
        this.italic = isItalic;
    }

    public FontFace(String fontName, int style) {
        this.name = fontName;
        this.bold = (style & 1) != 0;
        this.italic = (style & 2) != 0;
    }

    public String getName() {
        return this.name;
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public int getStyle() {
        int style = 0;
        if (this.bold) {
            style |= 1;
        } else if (this.italic) {
            style |= 2;
        }
        return style;
    }

    public String toString() {
        return this.name + (this.bold ? " Bold" : "") + (this.italic ? " Italic" : "");
    }

    public boolean equals(Object object) {
        boolean result;
        if (object == null) {
            result = false;
        } else if (object == this) {
            result = true;
        } else if (object instanceof FontFace) {
            FontFace key = (FontFace)object;
            result = this.name.equals(this.name) && this.bold == key.bold && this.italic == key.italic;
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        return (this.name.hashCode() * 31 + Boolean.valueOf(this.bold).hashCode()) * 31 + Boolean.valueOf(this.italic).hashCode();
    }
}

