/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.util.font;

import com.flagstone.transform.util.font.FontDecoder;
import com.flagstone.transform.util.font.FontEncoding;
import com.flagstone.transform.util.font.FontProvider;
import java.util.LinkedHashMap;
import java.util.Map;

public final class FontRegistry {
    private static Map<String, FontProvider> providers = new LinkedHashMap<String, FontProvider>();

    public static void registerProvider(String mimeType, FontProvider decoder) {
        providers.put(mimeType, decoder);
    }

    public static FontDecoder getFontProvider(String type) {
        if (providers.containsKey(type)) {
            return providers.get(type).newDecoder();
        }
        throw new IllegalArgumentException();
    }

    private FontRegistry() {
    }

    static {
        for (FontEncoding encoding : FontEncoding.values()) {
            FontRegistry.registerProvider(encoding.getType(), encoding.getProvider());
        }
    }
}

