/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.util.image;

import com.flagstone.transform.coder.BigDecoder;
import com.flagstone.transform.image.DefineImage;
import com.flagstone.transform.image.DefineImage2;
import com.flagstone.transform.image.ImageFormat;
import com.flagstone.transform.image.ImageTag;
import com.flagstone.transform.util.image.ImageDecoder;
import com.flagstone.transform.util.image.ImageFilter;
import com.flagstone.transform.util.image.ImageInfo;
import com.flagstone.transform.util.image.ImageProvider;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public final class PNGDecoder
implements ImageProvider,
ImageDecoder {
    private static final int OPAQUE = 255;
    private static final int UNSIGNED_BYTE = 255;
    private static final int RGBA_CHANNELS = 4;
    private static final int RGB_CHANNELS = 3;
    private static final int RGB5_SIZE = 16;
    private static final int RGB8_SIZE = 24;
    private static final int RED = 0;
    private static final int GREEN = 1;
    private static final int BLUE = 2;
    private static final int ALPHA = 3;
    private static final int DEPTH_1 = 1;
    private static final int DEPTH_2 = 2;
    private static final int DEPTH_4 = 4;
    private static final int DEPTH_8 = 8;
    private static final int DEPTH_16 = 16;
    private static final String BAD_FORMAT = "Unsupported format";
    private static final int[] MONOCHROME = new int[]{0, 255};
    private static final int[] GREYCSALE2 = new int[]{0, 85, 170, 255};
    private static final int[] GREYCSALE4 = new int[]{0, 17, 34, 51, 68, 85, 102, 119, 136, 153, 170, 187, 204, 221, 238, 255};
    private static final int[] SIGNATURE = new int[]{137, 80, 78, 71, 13, 10, 26, 10};
    private static final int IHDR = 1229472850;
    private static final int PLTE = 1347179589;
    private static final int IDAT = 1229209940;
    private static final int IEND = 1229278788;
    private static final int TRNS = 1951551059;
    private static final int GREYSCALE = 0;
    private static final int TRUE_COLOUR = 2;
    private static final int INDEXED_COLOUR = 3;
    private static final int ALPHA_GREYSCALE = 4;
    private static final int ALPHA_TRUECOLOUR = 6;
    private static final int SUB_FILTER = 1;
    private static final int UP_FILTER = 2;
    private static final int AVG_FILTER = 3;
    private static final int PAETH_FILTER = 4;
    private static final int[] START_ROW = new int[]{0, 0, 4, 0, 2, 0, 1};
    private static final int[] START_COLUMN = new int[]{0, 4, 0, 2, 0, 1, 0};
    private static final int[] ROW_STEP = new int[]{8, 8, 8, 4, 4, 2, 2};
    private static final int[] COLUMN_STEP = new int[]{8, 8, 4, 4, 2, 2, 1};
    private transient int bitDepth;
    private transient int colorComponents;
    private transient int colorType;
    private transient int interlaceMethod;
    private transient int transparentGrey;
    private transient int transparentRed;
    private transient byte[] chunkData = new byte[0];
    private transient ImageFormat format;
    private transient int width;
    private transient int height;
    private transient byte[] table;
    private transient byte[] image;

    @Override
    public ImageDecoder newDecoder() {
        return new PNGDecoder();
    }

    @Override
    public void read(File file) throws IOException, DataFormatException {
        ImageInfo info = new ImageInfo();
        info.setInput(new RandomAccessFile(file, "r"));
        if (!info.check()) {
            throw new DataFormatException(BAD_FORMAT);
        }
        this.read(new FileInputStream(file));
    }

    @Override
    public void read(URL url) throws IOException, DataFormatException {
        URLConnection connection = url.openConnection();
        int length = connection.getContentLength();
        if (length < 0) {
            throw new FileNotFoundException(url.getFile());
        }
        this.read(url.openStream());
    }

    @Override
    public ImageTag defineImage(int identifier) {
        ImageTag object = null;
        ImageFilter filter = new ImageFilter();
        switch (this.format) {
            case IDX8: {
                object = new DefineImage(identifier, this.width, this.height, this.table.length / 4, this.zip(filter.merge(filter.adjustScan(this.width, this.height, this.image), this.table)));
                break;
            }
            case IDXA: {
                object = new DefineImage2(identifier, this.width, this.height, this.table.length / 4, this.zip(filter.mergeAlpha(filter.adjustScan(this.width, this.height, this.image), this.table)));
                break;
            }
            case RGB5: {
                object = new DefineImage(identifier, this.width, this.height, this.zip(filter.packColors(this.width, this.height, this.image)), 16);
                break;
            }
            case RGB8: {
                filter.orderAlpha(this.image);
                object = new DefineImage(identifier, this.width, this.height, this.zip(this.image), 24);
                break;
            }
            case RGBA: {
                this.applyAlpha(this.image);
                object = new DefineImage2(identifier, this.width, this.height, this.zip(this.image));
                break;
            }
            default: {
                throw new AssertionError((Object)BAD_FORMAT);
            }
        }
        return object;
    }

    private void applyAlpha(byte[] img) {
        for (int i = 0; i < img.length; i += 4) {
            int alpha = img[i + 3] & 0xFF;
            img[i + 3] = (byte)((img[i + 2] & 0xFF) * alpha / 255);
            img[i + 2] = (byte)((img[i + 1] & 0xFF) * alpha / 255);
            img[i + 1] = (byte)((img[i + 0] & 0xFF) * alpha / 255);
            img[i + 0] = (byte)alpha;
        }
    }

    @Override
    public void read(InputStream stream) throws DataFormatException, IOException {
        BigDecoder coder = new BigDecoder(stream);
        int length = 0;
        int chunkType = 0;
        boolean moreChunks = true;
        this.chunkData = new byte[0];
        this.transparentGrey = -1;
        this.transparentRed = -1;
        for (int i = 0; i < 8; ++i) {
            if (coder.readByte() == SIGNATURE[i]) continue;
            throw new DataFormatException(BAD_FORMAT);
        }
        block8: while (moreChunks) {
            length = coder.readInt();
            chunkType = coder.readInt();
            coder.mark();
            switch (chunkType) {
                case 1229472850: {
                    this.decodeIHDR(coder);
                    continue block8;
                }
                case 1347179589: {
                    this.decodePLTE(coder, length);
                    continue block8;
                }
                case 1951551059: {
                    this.decodeTRNS(coder, length);
                    continue block8;
                }
                case 1229209940: {
                    this.decodeIDAT(coder, length);
                    continue block8;
                }
                case 1229278788: {
                    moreChunks = false;
                    coder.skip(length + 4);
                    continue block8;
                }
            }
            coder.skip(length + 4);
        }
        this.decodeImage();
    }

    private void decodeIHDR(BigDecoder coder) throws IOException, DataFormatException {
        this.width = coder.readInt();
        this.height = coder.readInt();
        this.bitDepth = coder.readByte();
        this.colorType = coder.readByte();
        coder.readByte();
        coder.readByte();
        this.interlaceMethod = coder.readByte();
        coder.readInt();
        this.decodeFormat();
    }

    private void decodeFormat() throws DataFormatException {
        switch (this.colorType) {
            case 0: {
                this.format = ImageFormat.RGB8;
                this.colorComponents = 1;
                break;
            }
            case 2: {
                this.format = ImageFormat.RGB8;
                this.colorComponents = 3;
                break;
            }
            case 3: {
                this.format = ImageFormat.IDX8;
                this.colorComponents = 1;
                break;
            }
            case 4: {
                this.format = ImageFormat.RGBA;
                this.colorComponents = 2;
                break;
            }
            case 6: {
                this.format = ImageFormat.RGBA;
                this.colorComponents = 4;
                break;
            }
            default: {
                throw new DataFormatException(BAD_FORMAT);
            }
        }
        if (this.format == ImageFormat.RGB8 && this.bitDepth <= 5) {
            this.format = ImageFormat.RGB5;
        }
    }

    private void decodePLTE(BigDecoder coder, int length) throws IOException {
        if (this.colorType == 3) {
            int paletteSize = length / 3;
            int index = 0;
            this.table = new byte[paletteSize * 4];
            int i = 0;
            while (i < paletteSize) {
                this.table[index + 3] = -1;
                this.table[index + 2] = (byte)coder.readByte();
                this.table[index + 1] = (byte)coder.readByte();
                this.table[index + 0] = (byte)coder.readByte();
                ++i;
                index += 4;
            }
        } else {
            coder.skip(length);
        }
        coder.readInt();
    }

    private void decodeTRNS(BigDecoder coder, int length) throws IOException {
        int index = 0;
        switch (this.colorType) {
            case 0: {
                this.transparentGrey = coder.readUnsignedShort();
                this.format = ImageFormat.RGBA;
                break;
            }
            case 2: {
                this.transparentRed = coder.readUnsignedShort();
                this.format = ImageFormat.RGBA;
                coder.readUnsignedShort();
                coder.readUnsignedShort();
                break;
            }
            case 3: {
                this.format = ImageFormat.IDXA;
                int i = 0;
                while (i < length) {
                    this.table[index + 3] = (byte)coder.readByte();
                    if (this.table[index + 3] == 0) {
                        this.table[index + 0] = 0;
                        this.table[index + 1] = 0;
                        this.table[index + 2] = 0;
                    }
                    ++i;
                    index += 4;
                }
                break;
            }
        }
        coder.readInt();
    }

    private void decodeIDAT(BigDecoder coder, int length) throws IOException {
        int currentLength = this.chunkData.length;
        int newLength = currentLength + length;
        byte[] data = new byte[newLength];
        System.arraycopy(this.chunkData, 0, data, 0, currentLength);
        for (int i = currentLength; i < newLength; ++i) {
            data[i] = (byte)coder.readByte();
        }
        this.chunkData = data;
        coder.readInt();
    }

    private void decodeImage() throws IOException, DataFormatException {
        this.image = this.format == ImageFormat.IDX8 || this.format == ImageFormat.IDXA ? new byte[this.height * this.width] : new byte[this.height * this.width * 4];
        if (this.interlaceMethod == 1) {
            this.decodeInterlaced();
        } else {
            this.decodeProgressive();
        }
    }

    private void decodeInterlaced() throws IOException, DataFormatException {
        byte[] encodedImage = this.unzip(this.chunkData);
        int bitsPerPixel = this.bitDepth * this.colorComponents;
        int bitsPerRow = this.width * bitsPerPixel;
        int rowWidth = bitsPerRow + 7 >> 3;
        int bytesPerPixel = bitsPerPixel < 8 ? 1 : bitsPerPixel / 8;
        byte[] current = new byte[rowWidth];
        byte[] previous = new byte[rowWidth];
        for (int i = 0; i < rowWidth; ++i) {
            previous[i] = 0;
        }
        int imageIndex = 0;
        int row = 0;
        int col = 0;
        byte filter = 0;
        int scanBits = 0;
        int scanLength = 0;
        for (int pass = 0; pass < 7; ++pass) {
            for (row = START_ROW[pass]; row < this.height && imageIndex < encodedImage.length; row += ROW_STEP[pass]) {
                scanBits = 0;
                for (col = START_COLUMN[pass]; col < this.width; col += COLUMN_STEP[pass]) {
                    scanBits += bitsPerPixel;
                }
                scanLength = scanBits + 7 >> 3;
                filter = encodedImage[imageIndex++];
                int i = 0;
                while (i < scanLength) {
                    current[i] = imageIndex < encodedImage.length ? encodedImage[imageIndex] : previous[i];
                    ++i;
                    ++imageIndex;
                }
                this.defilter(filter, bytesPerPixel, scanLength, current, previous);
                this.deblock(row, current, START_COLUMN[pass], COLUMN_STEP[pass]);
                System.arraycopy(current, 0, previous, 0, scanLength);
            }
        }
    }

    private void decodeProgressive() throws IOException, DataFormatException {
        byte[] data = this.unzip(this.chunkData);
        int bitsPerPixel = this.bitDepth * this.colorComponents;
        int bitsPerRow = this.width * bitsPerPixel;
        int rowWidth = bitsPerRow + 7 >> 3;
        int bytesPerPixel = bitsPerPixel < 8 ? 1 : bitsPerPixel / 8;
        byte[] current = new byte[rowWidth];
        byte[] previous = new byte[rowWidth];
        for (int i = 0; i < rowWidth; ++i) {
            previous[i] = 0;
        }
        int index = 0;
        int row = 0;
        int col = 0;
        byte filter = 0;
        int scanBits = 0;
        int scanLength = 0;
        for (row = 0; row < this.height && index < data.length; ++row) {
            scanBits = 0;
            for (col = 0; col < this.width; ++col) {
                scanBits += bitsPerPixel;
            }
            scanLength = scanBits + 7 >> 3;
            filter = data[index++];
            int i = 0;
            while (i < scanLength) {
                current[i] = index < data.length ? data[index] : previous[i];
                ++i;
                ++index;
            }
            this.defilter(filter, bytesPerPixel, scanLength, current, previous);
            this.deblock(row, current, 0, 1);
            System.arraycopy(current, 0, previous, 0, scanLength);
        }
    }

    private void defilter(int filter, int size, int scan, byte[] current, byte[] previous) {
        switch (filter) {
            case 1: {
                this.subFilter(size, scan, current);
                break;
            }
            case 2: {
                this.upFilter(scan, current, previous);
                break;
            }
            case 3: {
                this.averageFilter(size, scan, current, previous);
                break;
            }
            case 4: {
                this.paethFilter(size, scan, current, previous);
                break;
            }
        }
    }

    private void subFilter(int start, int count, byte[] current) {
        int i = start;
        int j = 0;
        while (i < count) {
            current[i] = (byte)(current[i] + current[j]);
            ++i;
            ++j;
        }
    }

    private void upFilter(int count, byte[] current, byte[] previous) {
        for (int i = 0; i < count; ++i) {
            current[i] = (byte)(current[i] + previous[i]);
        }
    }

    private void averageFilter(int start, int count, byte[] current, byte[] previous) {
        int cindex;
        for (cindex = 0; cindex < start; ++cindex) {
            current[cindex] = (byte)(current[cindex] + (0 + (0xFF & previous[cindex])) / 2);
        }
        cindex = start;
        int pindex = 0;
        while (cindex < count) {
            current[cindex] = (byte)(current[cindex] + ((0xFF & current[pindex]) + (0xFF & previous[cindex])) / 2);
            ++cindex;
            ++pindex;
        }
    }

    private void paethFilter(int start, int count, byte[] current, byte[] previous) {
        int cindex;
        for (cindex = 0; cindex < start; ++cindex) {
            current[cindex] = (byte)(current[cindex] + this.paeth((byte)0, previous[cindex], (byte)0));
        }
        cindex = start;
        int pindex = 0;
        while (cindex < count) {
            current[cindex] = (byte)(current[cindex] + this.paeth(current[pindex], previous[cindex], previous[pindex]));
            ++cindex;
            ++pindex;
        }
    }

    private int paeth(byte lower, byte upper, byte next) {
        int distUpperLeft;
        int distAbove;
        int left = 0xFF & lower;
        int above = 0xFF & upper;
        int upperLeft = 0xFF & next;
        int estimate = left + above - upperLeft;
        int distLeft = estimate - left;
        if (distLeft < 0) {
            distLeft = -distLeft;
        }
        if ((distAbove = estimate - above) < 0) {
            distAbove = -distAbove;
        }
        if ((distUpperLeft = estimate - upperLeft) < 0) {
            distUpperLeft = -distUpperLeft;
        }
        int value = distLeft <= distAbove && distLeft <= distUpperLeft ? left : (distAbove <= distUpperLeft ? above : upperLeft);
        return value;
    }

    private void deblock(int row, byte[] current, int start, int inc) throws IOException, DataFormatException {
        ByteArrayInputStream stream = new ByteArrayInputStream(current);
        BigDecoder coder = new BigDecoder(stream);
        block7: for (int col = start; col < this.width; col += inc) {
            switch (this.colorType) {
                case 0: {
                    this.decodeGreyscale(coder, row, col);
                    continue block7;
                }
                case 2: {
                    this.decodeTrueColour(coder, row, col);
                    continue block7;
                }
                case 3: {
                    this.decodeIndexedColour(coder, row, col);
                    continue block7;
                }
                case 4: {
                    this.decodeAlphaGreyscale(coder, row, col);
                    continue block7;
                }
                case 6: {
                    this.decodeAlphaTrueColour(coder, row, col);
                    continue block7;
                }
                default: {
                    throw new DataFormatException(BAD_FORMAT);
                }
            }
        }
    }

    private void decodeGreyscale(BigDecoder coder, int row, int col) throws IOException, DataFormatException {
        int pixel = 0;
        byte colour = 0;
        switch (this.bitDepth) {
            case 1: {
                pixel = coder.readBits(this.bitDepth, false);
                colour = (byte)MONOCHROME[pixel];
                break;
            }
            case 2: {
                pixel = coder.readBits(this.bitDepth, false);
                colour = (byte)GREYCSALE2[pixel];
                break;
            }
            case 4: {
                pixel = coder.readBits(this.bitDepth, false);
                colour = (byte)GREYCSALE4[pixel];
                break;
            }
            case 8: {
                pixel = coder.readByte();
                colour = (byte)pixel;
                break;
            }
            case 16: {
                pixel = coder.readUnsignedShort();
                colour = (byte)(pixel >> 8);
                break;
            }
            default: {
                throw new DataFormatException(BAD_FORMAT);
            }
        }
        int index = row * (this.width << 2) + (col << 2);
        this.image[index++] = colour;
        this.image[index++] = colour;
        this.image[index++] = colour;
        this.image[index++] = (byte)this.transparentGrey;
    }

    private void decodeTrueColour(BigDecoder coder, int row, int col) throws IOException, DataFormatException {
        int pixel = 0;
        byte colour = 0;
        int index = row * (this.width << 2) + (col << 2);
        for (int i = 0; i < this.colorComponents; ++i) {
            if (this.bitDepth == 8) {
                pixel = coder.readByte();
                colour = (byte)pixel;
            } else if (this.bitDepth == 16) {
                pixel = coder.readUnsignedShort();
                colour = (byte)(pixel >> 8);
            } else {
                throw new DataFormatException(BAD_FORMAT);
            }
            this.image[index + i] = colour;
        }
        this.image[index + 3] = (byte)this.transparentRed;
    }

    private void decodeIndexedColour(BigDecoder coder, int row, int col) throws IOException, DataFormatException {
        int index = 0;
        switch (this.bitDepth) {
            case 1: {
                index = coder.readBits(this.bitDepth, false);
                break;
            }
            case 2: {
                index = coder.readBits(this.bitDepth, false);
                break;
            }
            case 4: {
                index = coder.readBits(this.bitDepth, false);
                break;
            }
            case 8: {
                index = coder.readByte();
                break;
            }
            case 16: {
                index = coder.readUnsignedShort();
                break;
            }
            default: {
                throw new DataFormatException(BAD_FORMAT);
            }
        }
        this.image[row * this.width + col] = (byte)index;
    }

    private void decodeAlphaGreyscale(BigDecoder coder, int row, int col) throws IOException, DataFormatException {
        int pixel = 0;
        byte colour = 0;
        int alpha = 0;
        switch (this.bitDepth) {
            case 1: {
                pixel = coder.readBits(this.bitDepth, false);
                colour = (byte)MONOCHROME[pixel];
                alpha = coder.readBits(this.bitDepth, false);
                break;
            }
            case 2: {
                pixel = coder.readBits(this.bitDepth, false);
                colour = (byte)GREYCSALE2[pixel];
                alpha = coder.readBits(this.bitDepth, false);
                break;
            }
            case 4: {
                pixel = coder.readBits(this.bitDepth, false);
                colour = (byte)GREYCSALE4[pixel];
                alpha = coder.readBits(this.bitDepth, false);
                break;
            }
            case 8: {
                pixel = coder.readByte();
                colour = (byte)pixel;
                alpha = coder.readByte();
                break;
            }
            case 16: {
                pixel = coder.readUnsignedShort();
                colour = (byte)(pixel >> 8);
                alpha = coder.readUnsignedShort() >> 8;
                break;
            }
            default: {
                throw new DataFormatException(BAD_FORMAT);
            }
        }
        int index = row * (this.width << 2) + (col << 2);
        this.image[index++] = colour;
        this.image[index++] = colour;
        this.image[index++] = colour;
        this.image[index] = (byte)alpha;
    }

    private void decodeAlphaTrueColour(BigDecoder coder, int row, int col) throws IOException, DataFormatException {
        int pixel = 0;
        byte colour = 0;
        int index = row * (this.width << 2) + (col << 2);
        for (int i = 0; i < this.colorComponents; ++i) {
            if (this.bitDepth == 8) {
                pixel = coder.readByte();
                colour = (byte)pixel;
            } else if (this.bitDepth == 16) {
                pixel = coder.readUnsignedShort();
                colour = (byte)(pixel >> 8);
            } else {
                throw new DataFormatException(BAD_FORMAT);
            }
            this.image[index + i] = colour;
        }
    }

    private byte[] unzip(byte[] bytes) throws DataFormatException {
        byte[] data = new byte[this.width * this.height * 8];
        int count = 0;
        Inflater inflater = new Inflater();
        inflater.setInput(bytes);
        count = inflater.inflate(data);
        byte[] uncompressedData = new byte[count];
        System.arraycopy(data, 0, uncompressedData, 0, count);
        return uncompressedData;
    }

    private byte[] zip(byte[] img) {
        Deflater deflater = new Deflater();
        deflater.setInput(img);
        deflater.finish();
        byte[] compressedData = new byte[img.length * 2];
        int bytesCompressed = deflater.deflate(compressedData);
        byte[] newData = Arrays.copyOf(compressedData, bytesCompressed);
        return newData;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public byte[] getImage() {
        return Arrays.copyOf(this.image, this.image.length);
    }
}

