/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.video;

import com.flagstone.transform.coder.Copyable;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.video.ImageBlock;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class ScreenPacket
implements Copyable<ScreenPacket> {
    private static final int PIXELS_PER_BLOCK = 16;
    private boolean keyFrame;
    private int blockWidth;
    private int blockHeight;
    private int imageWidth;
    private int imageHeight;
    private List<ImageBlock> imageBlocks;

    public ScreenPacket(byte[] data) throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        SWFDecoder coder = new SWFDecoder(stream);
        int info = coder.readByte();
        this.keyFrame = (info & 0xF0) != 0;
        info = (coder.readByte() << 8) + coder.readByte();
        this.blockWidth = (((info & 0xF000) >> 12) + 1) * 16;
        this.imageWidth = info & 0xFFF;
        info = (coder.readByte() << 8) + coder.readByte();
        this.blockHeight = (((info & 0xF000) >> 12) + 1) * 16;
        this.imageHeight = info & 0xFFF;
        int columns = this.imageWidth / this.blockWidth + (this.imageWidth % this.blockWidth > 0 ? 1 : 0);
        int rows = this.imageHeight / this.blockHeight + (this.imageHeight % this.blockHeight > 0 ? 1 : 0);
        int height = this.imageHeight;
        int width = this.imageWidth;
        this.imageBlocks.clear();
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                ImageBlock block;
                int length = (coder.readByte() << 8) + coder.readByte();
                if (length == 0) {
                    block = new ImageBlock(0, 0, null);
                } else {
                    int dataHeight = height < this.blockHeight ? height : this.blockHeight;
                    int dataWidth = width < this.blockWidth ? width : this.blockWidth;
                    block = new ImageBlock(dataHeight, dataWidth, coder.readBytes(new byte[length]));
                }
                this.imageBlocks.add(block);
                ++j;
                width -= this.blockWidth;
            }
            ++i;
            height -= this.blockHeight;
        }
    }

    public ScreenPacket() {
        this.imageBlocks = new ArrayList<ImageBlock>();
    }

    public ScreenPacket(boolean key, int imgWidth, int imgHeight, int blkWidth, int blkHeight, List<ImageBlock> blocks) {
        this.setKeyFrame(key);
        this.setImageWidth(imgWidth);
        this.setImageHeight(imgHeight);
        this.setBlockWidth(blkWidth);
        this.setBlockHeight(blkHeight);
        this.setImageBlocks(blocks);
    }

    public ScreenPacket(ScreenPacket object) {
        this.keyFrame = object.keyFrame;
        this.blockWidth = object.blockWidth;
        this.blockHeight = object.blockHeight;
        this.imageWidth = object.imageWidth;
        this.imageHeight = object.imageHeight;
        this.imageBlocks = new ArrayList<ImageBlock>(object.imageBlocks.size());
        for (ImageBlock block : object.imageBlocks) {
            this.imageBlocks.add(block.copy());
        }
    }

    public ScreenPacket add(ImageBlock block) {
        this.imageBlocks.add(block);
        return this;
    }

    public boolean isKeyFrame() {
        return this.keyFrame;
    }

    public void setKeyFrame(boolean key) {
        this.keyFrame = key;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(int width) {
        this.imageWidth = width;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public void setImageHeight(int height) {
        this.imageHeight = height;
    }

    public int getBlockWidth() {
        return this.blockWidth;
    }

    public void setBlockWidth(int width) {
        this.blockWidth = width;
    }

    public int getBlockHeight() {
        return this.blockHeight;
    }

    public void setBlockHeight(int height) {
        this.blockHeight = height;
    }

    public List<ImageBlock> getImageBlocks() {
        return this.imageBlocks;
    }

    public void setImageBlocks(List<ImageBlock> blocks) {
        this.imageBlocks = new ArrayList<ImageBlock>(blocks);
    }

    @Override
    public ScreenPacket copy() {
        return new ScreenPacket(this);
    }

    public byte[] encode() throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        SWFEncoder coder = new SWFEncoder(stream);
        int bits = this.keyFrame ? 16 : 32;
        coder.writeByte(bits |= 3);
        int word = this.blockWidth / 16 - 1 << 4;
        coder.writeByte((word |= this.imageWidth & 0xFFF) >> 8);
        coder.writeByte(word);
        word = this.blockHeight / 16 - 1 << 4;
        coder.writeByte((word |= this.imageHeight & 0xFFF) >> 8);
        coder.writeByte(word);
        for (ImageBlock block : this.imageBlocks) {
            if (block.isEmpty()) {
                coder.writeShort(0);
                continue;
            }
            byte[] blockData = block.getBlock();
            coder.writeByte(blockData.length >> 8);
            coder.writeByte(blockData.length);
            coder.writeBytes(blockData);
        }
        return stream.toByteArray();
    }
}

