/*
 * Decompiled with CFR 0.152.
 */
package com.github.cloudyrock.mongock.driver.mongodb.springdata.v2.decorator;

import com.github.cloudyrock.mongock.driver.api.lock.guard.invoker.LockGuardInvoker;
import com.mongodb.ClientSessionOptions;
import com.mongodb.ServerAddress;
import com.mongodb.TransactionOptions;
import com.mongodb.client.ClientSession;
import com.mongodb.client.TransactionBody;
import com.mongodb.session.ServerSession;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;

public interface ClientSessionDecorator
extends ClientSession {
    public ClientSession getImpl();

    public LockGuardInvoker getInvoker();

    default public ServerAddress getPinnedServerAddress() {
        return this.getImpl().getPinnedServerAddress();
    }

    default public void setPinnedServerAddress(ServerAddress address) {
        this.getImpl().setPinnedServerAddress(address);
    }

    default public BsonDocument getRecoveryToken() {
        return this.getImpl().getRecoveryToken();
    }

    default public void setRecoveryToken(BsonDocument recoveryToken) {
        this.getImpl().setRecoveryToken(recoveryToken);
    }

    default public ClientSessionOptions getOptions() {
        return this.getImpl().getOptions();
    }

    default public boolean isCausallyConsistent() {
        return this.getImpl().isCausallyConsistent();
    }

    default public Object getOriginator() {
        return this.getImpl().getOriginator();
    }

    default public ServerSession getServerSession() {
        return this.getImpl().getServerSession();
    }

    default public BsonTimestamp getOperationTime() {
        return this.getImpl().getOperationTime();
    }

    default public void advanceOperationTime(BsonTimestamp operationTime) {
        this.getImpl().advanceOperationTime(operationTime);
    }

    default public void advanceClusterTime(BsonDocument clusterTime) {
        this.getImpl().advanceClusterTime(clusterTime);
    }

    default public BsonDocument getClusterTime() {
        return this.getImpl().getClusterTime();
    }

    default public void close() {
        this.getInvoker().invoke(() -> this.getImpl().close());
    }

    default public boolean hasActiveTransaction() {
        return this.getImpl().hasActiveTransaction();
    }

    default public boolean notifyMessageSent() {
        return this.getImpl().notifyMessageSent();
    }

    default public TransactionOptions getTransactionOptions() {
        return this.getImpl().getTransactionOptions();
    }

    default public void startTransaction() {
        this.getInvoker().invoke(() -> this.getImpl().startTransaction());
    }

    default public void startTransaction(TransactionOptions transactionOptions) {
        this.getInvoker().invoke(() -> this.getImpl().startTransaction(transactionOptions));
    }

    default public void commitTransaction() {
        this.getInvoker().invoke(() -> this.getImpl().commitTransaction());
    }

    default public void abortTransaction() {
        this.getInvoker().invoke(() -> this.getImpl().abortTransaction());
    }

    default public <T> T withTransaction(TransactionBody<T> transactionBody) {
        return (T)this.getInvoker().invoke(() -> this.getImpl().withTransaction(transactionBody));
    }

    default public <T> T withTransaction(TransactionBody<T> transactionBody, TransactionOptions options) {
        return (T)this.getInvoker().invoke(() -> this.getImpl().withTransaction(transactionBody, options));
    }
}

