/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.mojo;

import com.github.eirslett.maven.plugins.frontend.lib.AtlassianDevMetricsInstallationWork;
import com.github.eirslett.maven.plugins.frontend.lib.AtlassianDevMetricsReporter;
import com.github.eirslett.maven.plugins.frontend.lib.FrontendPluginFactory;
import com.github.eirslett.maven.plugins.frontend.lib.InstallationException;
import com.github.eirslett.maven.plugins.frontend.lib.ProxyConfig;
import com.github.eirslett.maven.plugins.frontend.mojo.AbstractFrontendMojo;
import com.github.eirslett.maven.plugins.frontend.mojo.MojoUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.crypto.SettingsDecrypter;

@Mojo(name="install-bun", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public final class InstallBunMojo
extends AbstractFrontendMojo {
    @Parameter(property="bunVersion", required=true)
    private String bunVersion;
    @Parameter(property="serverId", defaultValue="")
    private String serverId;
    @Parameter(property="session", defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(property="skip.installbun", alias="skip.installbun", defaultValue="${skip.installbun}")
    private boolean skip;
    @Component(role=SettingsDecrypter.class)
    private SettingsDecrypter decrypter;

    @Override
    protected boolean skipExecution() {
        return this.skip;
    }

    @Override
    public void execute(FrontendPluginFactory factory) throws InstallationException {
        AtlassianDevMetricsInstallationWork finalRuntimeInstallationWork;
        boolean finalTriedToUsePac;
        boolean finalPacAttemptFailed;
        boolean finalFailed;
        boolean failed = false;
        AtlassianDevMetricsReporter.Timer timer = new AtlassianDevMetricsReporter.Timer();
        AtlassianDevMetricsInstallationWork runtimeInstallationWork = AtlassianDevMetricsInstallationWork.UNKNOWN;
        try {
            ProxyConfig proxyConfig = MojoUtils.getProxyConfig(this.session, this.decrypter);
            Server server = MojoUtils.decryptServer(this.serverId, this.session, this.decrypter);
            runtimeInstallationWork = null != server ? factory.getBunInstaller(proxyConfig).setBunVersion(this.bunVersion).setUserName(server.getUsername()).setPassword(server.getPassword()).setHttpHeaders(this.getHttpHeaders(server)).install() : factory.getBunInstaller(proxyConfig).setBunVersion(this.bunVersion).install();
            finalFailed = failed;
            finalPacAttemptFailed = false;
            finalTriedToUsePac = false;
            finalRuntimeInstallationWork = runtimeInstallationWork;
        }
        catch (Exception exception) {
            try {
                failed = true;
                throw exception;
            }
            catch (Throwable throwable) {
                boolean finalFailed2 = failed;
                boolean finalPacAttemptFailed2 = false;
                boolean finalTriedToUsePac2 = false;
                AtlassianDevMetricsInstallationWork finalRuntimeInstallationWork2 = runtimeInstallationWork;
                timer.stop("runtime.download", this.project.getArtifactId(), this.getFrontendMavenPluginVersion(), AtlassianDevMetricsReporter.formatBunVersionForMetric((String)this.bunVersion), (Map)new HashMap<String, String>(finalRuntimeInstallationWork2, finalTriedToUsePac2, finalPacAttemptFailed2, finalFailed2){
                    final /* synthetic */ AtlassianDevMetricsInstallationWork val$finalRuntimeInstallationWork;
                    final /* synthetic */ boolean val$finalTriedToUsePac;
                    final /* synthetic */ boolean val$finalPacAttemptFailed;
                    final /* synthetic */ boolean val$finalFailed;
                    {
                        this.val$finalRuntimeInstallationWork = atlassianDevMetricsInstallationWork;
                        this.val$finalTriedToUsePac = bl;
                        this.val$finalPacAttemptFailed = bl2;
                        this.val$finalFailed = bl3;
                        this.put("installation", "bun");
                        this.put("installation-work-runtime", this.val$finalRuntimeInstallationWork.toString());
                        this.put("runtime-host", AtlassianDevMetricsReporter.getHostForMetric(null, (String)"https://github.com/oven-sh/bun/releases/download/", (boolean)this.val$finalTriedToUsePac, (boolean)this.val$finalPacAttemptFailed));
                        this.put("failed", Boolean.toString(this.val$finalFailed));
                        this.put("pac-attempted-failed", Boolean.toString(this.val$finalPacAttemptFailed));
                        this.put("tried-to-use-pac", Boolean.toString(this.val$finalTriedToUsePac));
                    }
                });
                throw throwable;
            }
        }
        timer.stop("runtime.download", this.project.getArtifactId(), this.getFrontendMavenPluginVersion(), AtlassianDevMetricsReporter.formatBunVersionForMetric((String)this.bunVersion), (Map)new /* invalid duplicate definition of identical inner class */);
    }
}

