/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.AccessCheck;
import com.github.marschall.memoryfilesystem.AutoRelease;
import com.github.marschall.memoryfilesystem.AutoReleaseLock;
import com.github.marschall.memoryfilesystem.CurrentGroup;
import com.github.marschall.memoryfilesystem.CurrentUser;
import com.github.marschall.memoryfilesystem.EntryCreationContext;
import com.github.marschall.memoryfilesystem.FileAttributeViews;
import com.github.marschall.memoryfilesystem.InitializingFileAttributeView;
import com.github.marschall.memoryfilesystem.MemoryFileSystem;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.FileSystemException;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.nio.file.attribute.UserPrincipal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

abstract class MemoryEntry {
    private final String originalName;
    private long lastModifiedTime;
    private long lastAccessTime;
    private long creationTime;
    private final MemoryFileSystem fileSystem;
    private final ReadWriteLock lock;
    private final Map<String, InitializingFileAttributeView> additionalViews;

    MemoryEntry(String originalName, EntryCreationContext context) {
        long now;
        this.originalName = originalName;
        this.fileSystem = context.fileSystem;
        this.lock = new ReentrantReadWriteLock();
        this.lastAccessTime = now = this.getNow();
        this.lastModifiedTime = now;
        this.creationTime = now;
        if (context.additionalViews.isEmpty()) {
            this.additionalViews = Collections.emptyMap();
        } else if (context.additionalViews.size() == 1) {
            InitializingFileAttributeView view = this.instantiate(context.firstView(), context);
            this.additionalViews = Collections.singletonMap(view.name(), view);
        } else {
            this.additionalViews = new HashMap<String, InitializingFileAttributeView>(context.additionalViews.size());
            for (Class<? extends FileAttributeView> viewClass : context.additionalViews) {
                InitializingFileAttributeView view = this.instantiate(viewClass, context);
                this.additionalViews.put(view.name(), view);
            }
        }
    }

    void initializeAttributes(MemoryEntry other) throws IOException {
        try (AutoRelease lock = this.writeLock();){
            this.getBasicFileAttributeView().initializeFrom(other.getBasicFileAttributeView());
            for (InitializingFileAttributeView view : this.additionalViews.values()) {
                view.initializeFrom(other.additionalViews);
            }
        }
    }

    void initializeRoot() {
        try (AutoRelease lock = this.readLock();){
            for (InitializingFileAttributeView view : this.additionalViews.values()) {
                view.initializeRoot();
            }
        }
    }

    private InitializingFileAttributeView instantiate(Class<? extends FileAttributeView> viewClass, EntryCreationContext context) {
        if (viewClass == PosixFileAttributeView.class) {
            return new MemoryPosixFileAttributeView(context);
        }
        if (viewClass == DosFileAttributeView.class) {
            return new MemoryDosFileAttributeView();
        }
        if (viewClass == UserDefinedFileAttributeView.class) {
            return new MemoryUserDefinedFileAttributeView();
        }
        throw new IllegalArgumentException("unknown file attribute view: " + viewClass);
    }

    String getOriginalName() {
        return this.originalName;
    }

    long getNow() {
        return System.currentTimeMillis();
    }

    AutoRelease readLock() {
        return AutoReleaseLock.autoRelease(this.lock.readLock());
    }

    AutoRelease writeLock() {
        return AutoReleaseLock.autoRelease(this.lock.writeLock());
    }

    FileTime lastModifiedTime() {
        return FileTime.fromMillis(this.lastModifiedTime);
    }

    FileTime lastAccessTime() {
        return FileTime.fromMillis(this.lastAccessTime);
    }

    FileTime creationTime() {
        return FileTime.fromMillis(this.creationTime);
    }

    void checkAccess(AccessMode ... modes) throws AccessDeniedException {
        try (AutoRelease lock = this.readLock();){
            AccessMode unsupported = this.getUnsupported(modes);
            if (unsupported != null) {
                throw new UnsupportedOperationException("access mode " + (Object)((Object)unsupported) + " is not supported");
            }
            for (InitializingFileAttributeView attributeView : this.additionalViews.values()) {
                if (!(attributeView instanceof AccessCheck)) continue;
                AccessCheck accessCheck = (AccessCheck)((Object)attributeView);
                accessCheck.checkAccess(modes);
            }
        }
    }

    void checkAccess(AccessMode mode) throws AccessDeniedException {
        try (AutoRelease lock = this.readLock();){
            AccessMode unsupported = this.getUnsupported(mode);
            if (unsupported != null) {
                throw new UnsupportedOperationException("access mode " + (Object)((Object)unsupported) + " is not supported");
            }
            for (InitializingFileAttributeView attributeView : this.additionalViews.values()) {
                if (!(attributeView instanceof AccessCheck)) continue;
                AccessCheck accessCheck = (AccessCheck)((Object)attributeView);
                accessCheck.checkAccess(mode);
            }
        }
    }

    private AccessMode getUnsupported(AccessMode ... modes) {
        for (AccessMode mode : modes) {
            if (mode == AccessMode.READ || mode == AccessMode.WRITE || mode == AccessMode.EXECUTE) continue;
            return mode;
        }
        return null;
    }

    private AccessMode getUnsupported(AccessMode mode) {
        if (mode != AccessMode.READ && mode != AccessMode.WRITE && mode != AccessMode.EXECUTE) {
            return mode;
        }
        return null;
    }

    void modified() {
        long now;
        this.lastAccessTime = now = this.getNow();
        this.lastModifiedTime = now;
    }

    void accessed() {
        this.lastAccessTime = this.getNow();
    }

    void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws AccessDeniedException {
        try (AutoRelease lock = this.writeLock();){
            this.checkAccess(AccessMode.WRITE);
            if (lastModifiedTime != null) {
                this.lastModifiedTime = lastModifiedTime.toMillis();
            }
            if (lastAccessTime != null) {
                this.lastAccessTime = lastAccessTime.toMillis();
            }
            if (createTime != null) {
                this.creationTime = createTime.toMillis();
            }
        }
    }

    <A extends FileAttributeView> A getFileAttributeView(Class<A> type) throws AccessDeniedException {
        Throwable throwable = null;
        try (AutoRelease lock = this.readLock();){
            this.checkAccess(AccessMode.READ);
            if (type == BasicFileAttributeView.class) {
                InitializingFileAttributeView initializingFileAttributeView = this.getBasicFileAttributeView();
                return (A)initializingFileAttributeView;
            }
            String name = null;
            if (type == FileOwnerAttributeView.class) {
                if (this.additionalViews.containsKey("posix")) {
                    name = "posix";
                } else if (this.additionalViews.containsKey("acl")) {
                    name = "acl";
                }
            } else {
                name = FileAttributeViews.mapAttributeView(type);
            }
            if (name == null) {
                throw new UnsupportedOperationException("file attribute view" + type + " not supported");
            }
            FileAttributeView view = this.additionalViews.get(name);
            if (view != null) {
                FileAttributeView fileAttributeView = view;
                return (A)fileAttributeView;
            }
            try {
                throw new UnsupportedOperationException("file attribute view" + type + " not supported");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    <A extends BasicFileAttributes> A readAttributes(Class<A> type) throws IOException {
        Throwable throwable = null;
        try (AutoRelease lock = this.readLock();){
            this.checkAccess(AccessMode.READ);
            if (type == BasicFileAttributes.class) {
                BasicFileAttributes basicFileAttributes = this.getBasicFileAttributeView().readAttributes();
                return (A)basicFileAttributes;
            }
            String viewName = FileAttributeViews.mapFileAttributes(type);
            if (viewName == null) throw new UnsupportedOperationException("file attributes " + type + " not supported");
            FileAttributeView view = this.additionalViews.get(viewName);
            if (view instanceof BasicFileAttributeView) {
                BasicFileAttributes basicFileAttributes = ((BasicFileAttributeView)view).readAttributes();
                return (A)basicFileAttributes;
            }
            try {
                throw new UnsupportedOperationException("file attributes " + type + " not supported");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    abstract InitializingFileAttributeView getBasicFileAttributeView();

    static Set<PosixFilePermission> toSet(int mask) {
        EnumSet<PosixFilePermission> set = EnumSet.noneOf(PosixFilePermission.class);
        for (PosixFilePermission permission : PosixFilePermission.values()) {
            int flag = 1 << permission.ordinal() & mask;
            if (flag == 0) continue;
            set.add(permission);
        }
        return set;
    }

    static int toMask(Set<PosixFilePermission> permissions) {
        int mask = 0;
        for (PosixFilePermission permission : permissions) {
            mask |= 1 << permission.ordinal();
        }
        return mask;
    }

    class MemoryUserDefinedFileAttributeView
    extends DelegatingFileAttributesView
    implements UserDefinedFileAttributeView {
        private Map<String, byte[]> values;

        MemoryUserDefinedFileAttributeView() {
        }

        @Override
        public BasicFileAttributes readAttributes() throws IOException {
            throw new UnsupportedOperationException("readAttributes");
        }

        @Override
        void initializeFromSelf(FileAttributeView selfAttributes) {
            MemoryUserDefinedFileAttributeView other = (MemoryUserDefinedFileAttributeView)selfAttributes;
            if (other.values == null) {
                this.values = null;
            } else {
                this.values = new HashMap<String, byte[]>(other.values.size());
                for (Map.Entry<String, byte[]> entry : other.values.entrySet()) {
                    this.values.put(entry.getKey(), (byte[])entry.getValue().clone());
                }
            }
        }

        private Map<String, byte[]> getValues() {
            if (this.values == null) {
                this.values = new HashMap<String, byte[]>(3);
            }
            return this.values;
        }

        @Override
        public String name() {
            return "user";
        }

        @Override
        public List<String> list() throws IOException {
            try (AutoRelease lock = MemoryEntry.this.readLock();){
                if (this.values == null) {
                    List<String> list = Collections.emptyList();
                    return list;
                }
                Set<String> keys = this.getValues().keySet();
                ArrayList<String> arrayList = new ArrayList<String>(keys);
                return arrayList;
            }
        }

        @Override
        public int size(String name) throws IOException {
            try (AutoRelease lock = MemoryEntry.this.readLock();){
                byte[] value = this.getValue(name);
                int n = value.length;
                return n;
            }
        }

        private byte[] getValue(String name) throws IOException {
            if (name == null) {
                throw new NullPointerException("name is null");
            }
            if (this.values == null) {
                throw new FileSystemException(null, null, "attribute " + name + " not present");
            }
            byte[] value = this.values.get(name);
            if (value == null) {
                throw new FileSystemException(null, null, "attribute " + name + " not present");
            }
            return value;
        }

        @Override
        public int read(String name, ByteBuffer dst) throws IOException {
            try (AutoRelease lock = MemoryEntry.this.readLock();){
                byte[] value = this.getValue(name);
                int remaining = dst.remaining();
                int required = value.length;
                if (remaining < required) {
                    throw new FileSystemException(null, null, required + " bytes in buffer required but only " + remaining + " available");
                }
                int startPosition = dst.position();
                dst.put(value);
                int endPosition = dst.position();
                int n = endPosition - startPosition;
                return n;
            }
        }

        @Override
        public int write(String name, ByteBuffer src) throws IOException {
            try (AutoRelease lock = MemoryEntry.this.writeLock();){
                if (name == null) {
                    throw new NullPointerException("name is null");
                }
                if (src == null) {
                    throw new NullPointerException("buffer is null");
                }
                int remaining = src.remaining();
                byte[] dst = new byte[remaining];
                int startPosition = src.position();
                src.get(dst);
                int endPosition = src.position();
                this.getValues().put(name, dst);
                int n = endPosition - startPosition;
                return n;
            }
        }

        @Override
        public void delete(String name) throws IOException {
            try (AutoRelease lock = MemoryEntry.this.writeLock();){
                if (this.values != null) {
                    if (name == null) {
                        throw new NullPointerException("name is null");
                    }
                    this.values.remove(name);
                }
            }
        }
    }

    class MemoryPosixFileAttributeView
    extends MemoryFileOwnerAttributeView
    implements PosixFileAttributeView,
    AccessCheck {
        private GroupPrincipal group;
        private int perms;

        MemoryPosixFileAttributeView(EntryCreationContext context) {
            super(context);
            if (context.group == null) {
                throw new NullPointerException("group");
            }
            this.group = context.group;
            this.perms = MemoryEntry.toMask(context.umask);
        }

        @Override
        public String name() {
            return "posix";
        }

        @Override
        void initializeFromSelf(FileAttributeView selfAttributes) {
            MemoryPosixFileAttributeView other = (MemoryPosixFileAttributeView)selfAttributes;
            this.group = other.group;
            this.perms = other.perms;
        }

        @Override
        public void setGroup(GroupPrincipal group) throws IOException {
            if (group == null) {
                throw new IllegalArgumentException("group must not be null");
            }
            try (AutoRelease lock = MemoryEntry.this.writeLock();){
                MemoryEntry.this.checkAccess(AccessMode.WRITE);
                this.group = group;
            }
        }

        @Override
        public PosixFileAttributes readAttributes() throws IOException {
            MemoryEntry.this.checkAccess(AccessMode.READ);
            try (AutoRelease lock = MemoryEntry.this.readLock();){
                BasicFileAttributeView view = MemoryEntry.this.getFileAttributeView(BasicFileAttributeView.class);
                MemoryPosixFileAttributes memoryPosixFileAttributes = new MemoryPosixFileAttributes(view.readAttributes(), this.getOwner(), this.group, MemoryEntry.toSet(this.perms));
                return memoryPosixFileAttributes;
            }
        }

        @Override
        public void setPermissions(Set<PosixFilePermission> perms) throws IOException {
            if (perms == null) {
                throw new IllegalArgumentException("permissions must not be null");
            }
            try (AutoRelease lock = MemoryEntry.this.writeLock();){
                MemoryEntry.this.checkAccess(AccessMode.WRITE);
                this.perms = MemoryEntry.toMask(perms);
            }
        }

        private UserPrincipal getCurrentUser() {
            UserPrincipal user = CurrentUser.get();
            if (user == null) {
                return MemoryEntry.this.fileSystem.getUserPrincipalLookupService().getDefaultUser();
            }
            return user;
        }

        private GroupPrincipal getCurrentGroup() {
            return CurrentGroup.get();
        }

        @Override
        public void checkAccess(AccessMode mode) throws AccessDeniedException {
            GroupPrincipal group;
            UserPrincipal user = this.getCurrentUser();
            PosixFilePermission permission = user == this.getOwner() ? this.translateOwnerMode(mode) : ((group = this.getCurrentGroup()) == this.group ? this.translateGroupMode(mode) : this.translateOthersMode(mode));
            int flag = 1 << permission.ordinal() & this.perms;
            if (flag == 0) {
                throw new AccessDeniedException(null);
            }
        }

        @Override
        public void checkAccess(AccessMode[] modes) throws AccessDeniedException {
            for (AccessMode mode : modes) {
                this.checkAccess(mode);
            }
        }

        private PosixFilePermission translateOwnerMode(AccessMode mode) {
            switch (mode) {
                case READ: {
                    return PosixFilePermission.OWNER_READ;
                }
                case WRITE: {
                    return PosixFilePermission.OWNER_WRITE;
                }
                case EXECUTE: {
                    return PosixFilePermission.OWNER_EXECUTE;
                }
            }
            throw new UnsupportedOperationException("access mode " + (Object)((Object)mode) + " is not supported");
        }

        private PosixFilePermission translateGroupMode(AccessMode mode) {
            switch (mode) {
                case READ: {
                    return PosixFilePermission.GROUP_READ;
                }
                case WRITE: {
                    return PosixFilePermission.GROUP_WRITE;
                }
                case EXECUTE: {
                    return PosixFilePermission.GROUP_EXECUTE;
                }
            }
            throw new UnsupportedOperationException("access mode " + (Object)((Object)mode) + " is not supported");
        }

        private PosixFilePermission translateOthersMode(AccessMode mode) {
            switch (mode) {
                case READ: {
                    return PosixFilePermission.OTHERS_READ;
                }
                case WRITE: {
                    return PosixFilePermission.OTHERS_WRITE;
                }
                case EXECUTE: {
                    return PosixFilePermission.OTHERS_EXECUTE;
                }
            }
            throw new UnsupportedOperationException("access mode " + (Object)((Object)mode) + " is not supported");
        }
    }

    abstract class MemoryFileOwnerAttributeView
    extends DelegatingFileAttributesView
    implements FileOwnerAttributeView {
        private UserPrincipal owner;

        MemoryFileOwnerAttributeView(EntryCreationContext context) {
            if (context.user == null) {
                throw new NullPointerException("owner");
            }
            this.owner = context.user;
        }

        @Override
        public UserPrincipal getOwner() {
            try (AutoRelease lock = MemoryEntry.this.readLock();){
                UserPrincipal userPrincipal = this.owner;
                return userPrincipal;
            }
        }

        @Override
        public void setOwner(UserPrincipal owner) throws IOException {
            if (owner == null) {
                throw new IllegalArgumentException("owner must not be null");
            }
            try (AutoRelease lock = MemoryEntry.this.writeLock();){
                MemoryEntry.this.checkAccess(AccessMode.WRITE);
                this.owner = owner;
            }
        }
    }

    static class MemoryDosFileAttributes
    extends DelegatingAttributes
    implements DosFileAttributes {
        private final boolean readOnly;
        private final boolean hidden;
        private final boolean system;
        private final boolean archive;

        MemoryDosFileAttributes(BasicFileAttributes delegate, boolean readOnly, boolean hidden, boolean system, boolean archive) {
            super(delegate);
            this.readOnly = readOnly;
            this.hidden = hidden;
            this.system = system;
            this.archive = archive;
        }

        @Override
        public boolean isReadOnly() {
            return this.readOnly;
        }

        @Override
        public boolean isHidden() {
            return this.hidden;
        }

        @Override
        public boolean isArchive() {
            return this.archive;
        }

        @Override
        public boolean isSystem() {
            return this.system;
        }
    }

    static class MemoryPosixFileAttributes
    extends DelegatingAttributes
    implements PosixFileAttributes {
        private final UserPrincipal owner;
        private final GroupPrincipal group;
        private final Set<PosixFilePermission> permissions;

        MemoryPosixFileAttributes(BasicFileAttributes delegate, UserPrincipal owner, GroupPrincipal group, Set<PosixFilePermission> permissions) {
            super(delegate);
            this.owner = owner;
            this.group = group;
            this.permissions = permissions;
        }

        @Override
        public UserPrincipal owner() {
            return this.owner;
        }

        @Override
        public GroupPrincipal group() {
            return this.group;
        }

        @Override
        public Set<PosixFilePermission> permissions() {
            return this.permissions;
        }
    }

    static class DelegatingAttributes
    implements BasicFileAttributes {
        private final BasicFileAttributes delegate;

        DelegatingAttributes(BasicFileAttributes delegate) {
            this.delegate = delegate;
        }

        @Override
        public FileTime lastModifiedTime() {
            return this.delegate.lastModifiedTime();
        }

        @Override
        public FileTime lastAccessTime() {
            return this.delegate.lastAccessTime();
        }

        @Override
        public FileTime creationTime() {
            return this.delegate.creationTime();
        }

        @Override
        public boolean isRegularFile() {
            return this.delegate.isRegularFile();
        }

        @Override
        public boolean isDirectory() {
            return this.delegate.isDirectory();
        }

        @Override
        public boolean isSymbolicLink() {
            return this.delegate.isSymbolicLink();
        }

        @Override
        public boolean isOther() {
            return this.delegate.isOther();
        }

        @Override
        public long size() {
            return this.delegate.size();
        }

        @Override
        public Object fileKey() {
            return this.delegate.fileKey();
        }
    }

    class MemoryDosFileAttributeView
    extends DelegatingFileAttributesView
    implements DosFileAttributeView,
    AccessCheck {
        private boolean readOnly;
        private boolean hidden;
        private boolean system;
        private boolean archive;

        MemoryDosFileAttributeView() {
        }

        @Override
        public String name() {
            return "dos";
        }

        @Override
        public void initializeRoot() {
            this.hidden = true;
            this.system = true;
        }

        @Override
        public DosFileAttributes readAttributes() throws IOException {
            MemoryEntry.this.checkAccess(AccessMode.READ);
            try (AutoRelease lock = MemoryEntry.this.readLock();){
                BasicFileAttributeView view = MemoryEntry.this.getFileAttributeView(BasicFileAttributeView.class);
                MemoryDosFileAttributes memoryDosFileAttributes = new MemoryDosFileAttributes(view.readAttributes(), this.readOnly, this.hidden, this.system, this.archive);
                return memoryDosFileAttributes;
            }
        }

        @Override
        void initializeFromSelf(FileAttributeView selfAttributes) {
            MemoryDosFileAttributeView other = (MemoryDosFileAttributeView)selfAttributes;
            this.readOnly = other.readOnly;
            this.hidden = other.hidden;
            this.system = other.system;
            this.archive = other.archive;
        }

        @Override
        public void setReadOnly(boolean value) throws IOException {
            try (AutoRelease lock = MemoryEntry.this.writeLock();){
                this.readOnly = value;
            }
        }

        @Override
        public void setHidden(boolean value) throws IOException {
            try (AutoRelease lock = MemoryEntry.this.writeLock();){
                this.hidden = value;
            }
        }

        @Override
        public void setSystem(boolean value) throws IOException {
            try (AutoRelease lock = MemoryEntry.this.writeLock();){
                this.system = value;
            }
        }

        @Override
        public void setArchive(boolean value) throws IOException {
            try (AutoRelease lock = MemoryEntry.this.writeLock();){
                this.archive = value;
            }
        }

        @Override
        public void checkAccess(AccessMode mode) throws AccessDeniedException {
            switch (mode) {
                case READ: {
                    break;
                }
                case WRITE: {
                    if (!this.readOnly) break;
                    throw new AccessDeniedException(null);
                }
                case EXECUTE: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("access mode " + (Object)((Object)mode) + " is not supported");
                }
            }
        }

        @Override
        public void checkAccess(AccessMode[] modes) throws AccessDeniedException {
            for (AccessMode mode : modes) {
                this.checkAccess(mode);
            }
        }
    }

    abstract class MemoryAclFileAttributeView
    extends MemoryFileOwnerAttributeView
    implements AclFileAttributeView,
    AccessCheck {
        private List<AclEntry> acl;

        MemoryAclFileAttributeView(EntryCreationContext context) {
            super(context);
        }

        @Override
        public String name() {
            return "acl";
        }

        @Override
        public void setAcl(List<AclEntry> acl) throws IOException {
            try (AutoRelease lock = MemoryEntry.this.writeLock();){
                this.acl = new ArrayList<AclEntry>(acl);
            }
        }

        @Override
        public List<AclEntry> getAcl() throws IOException {
            try (AutoRelease lock = MemoryEntry.this.readLock();){
                ArrayList<AclEntry> arrayList = new ArrayList<AclEntry>(this.acl);
                return arrayList;
            }
        }
    }

    abstract class DelegatingFileAttributesView
    implements BasicFileAttributeView,
    InitializingFileAttributeView {
        DelegatingFileAttributesView() {
        }

        @Override
        public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
            MemoryEntry.this.getBasicFileAttributeView().setTimes(lastModifiedTime, lastAccessTime, createTime);
        }

        @Override
        public void initializeFrom(BasicFileAttributeView basicFileAttributeView) {
        }

        @Override
        public void initializeRoot() {
        }

        @Override
        public void initializeFrom(Map<String, ? extends FileAttributeView> additionalAttributes) {
            FileAttributeView selfAttributes = additionalAttributes.get(this.name());
            if (selfAttributes != null) {
                this.initializeFromSelf(selfAttributes);
            }
        }

        abstract void initializeFromSelf(FileAttributeView var1);
    }

    static abstract class MemoryEntryFileAttributes
    implements BasicFileAttributes {
        private final FileTime lastModifiedTime;
        private final FileTime lastAccessTime;
        private final FileTime creationTime;
        private final Object fileKey;

        MemoryEntryFileAttributes(Object fileKey, FileTime lastModifiedTime, FileTime lastAccessTime, FileTime creationTime) {
            this.fileKey = fileKey;
            this.lastModifiedTime = lastModifiedTime;
            this.lastAccessTime = lastAccessTime;
            this.creationTime = creationTime;
        }

        @Override
        public FileTime lastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public FileTime lastAccessTime() {
            return this.lastAccessTime;
        }

        @Override
        public FileTime creationTime() {
            return this.creationTime;
        }

        @Override
        public Object fileKey() {
            return this.fileKey;
        }
    }

    abstract class MemoryEntryFileAttributesView
    implements InitializingFileAttributeView {
        MemoryEntryFileAttributesView() {
        }

        @Override
        public String name() {
            return "basic";
        }

        @Override
        public void initializeFrom(BasicFileAttributeView basicFileAttributeView) throws IOException {
            BasicFileAttributes otherAttributes = basicFileAttributeView.readAttributes();
            this.setTimes(otherAttributes.lastModifiedTime(), otherAttributes.lastAccessTime(), otherAttributes.creationTime());
        }

        @Override
        public void initializeFrom(Map<String, ? extends FileAttributeView> additionalAttributes) {
        }

        @Override
        public void initializeRoot() {
        }

        @Override
        public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
            MemoryEntry.this.setTimes(lastModifiedTime, lastAccessTime, createTime);
        }
    }
}

