/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.com.sun.nio.zipfs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.regex.PatternSyntaxException;

class ZipUtils {
    private static final long WINDOWS_EPOCH_IN_MICROSECONDS = -11644473600000000L;
    private static final String regexMetaChars = ".^$+{[]|()";
    private static final String globMetaChars = "\\*?[{";
    private static char EOL = '\u0000';

    ZipUtils() {
    }

    public static void writeShort(OutputStream os, int v) throws IOException {
        os.write(v & 0xFF);
        os.write(v >>> 8 & 0xFF);
    }

    public static void writeInt(OutputStream os, long v) throws IOException {
        os.write((int)(v & 0xFFL));
        os.write((int)(v >>> 8 & 0xFFL));
        os.write((int)(v >>> 16 & 0xFFL));
        os.write((int)(v >>> 24 & 0xFFL));
    }

    public static void writeLong(OutputStream os, long v) throws IOException {
        os.write((int)(v & 0xFFL));
        os.write((int)(v >>> 8 & 0xFFL));
        os.write((int)(v >>> 16 & 0xFFL));
        os.write((int)(v >>> 24 & 0xFFL));
        os.write((int)(v >>> 32 & 0xFFL));
        os.write((int)(v >>> 40 & 0xFFL));
        os.write((int)(v >>> 48 & 0xFFL));
        os.write((int)(v >>> 56 & 0xFFL));
    }

    public static void writeBytes(OutputStream os, byte[] b) throws IOException {
        os.write(b, 0, b.length);
    }

    public static void writeBytes(OutputStream os, byte[] b, int off, int len) throws IOException {
        os.write(b, off, len);
    }

    public static byte[] toDirectoryPath(byte[] dir) {
        if (dir.length != 0 && dir[dir.length - 1] != 47) {
            dir = Arrays.copyOf(dir, dir.length + 1);
            dir[dir.length - 1] = 47;
        }
        return dir;
    }

    public static long dosToJavaTime(long dtime) {
        Date d = new Date((int)((dtime >> 25 & 0x7FL) + 80L), (int)((dtime >> 21 & 0xFL) - 1L), (int)(dtime >> 16 & 0x1FL), (int)(dtime >> 11 & 0x1FL), (int)(dtime >> 5 & 0x3FL), (int)(dtime << 1 & 0x3EL));
        return d.getTime();
    }

    public static long javaToDosTime(long time) {
        Date d = new Date(time);
        int year = d.getYear() + 1900;
        if (year < 1980) {
            return 0x210000L;
        }
        return year - 1980 << 25 | d.getMonth() + 1 << 21 | d.getDate() << 16 | d.getHours() << 11 | d.getMinutes() << 5 | d.getSeconds() >> 1;
    }

    public static final long winToJavaTime(long wtime) {
        return TimeUnit.MILLISECONDS.convert(wtime / 10L + -11644473600000000L, TimeUnit.MICROSECONDS);
    }

    public static final long javaToWinTime(long time) {
        return (TimeUnit.MICROSECONDS.convert(time, TimeUnit.MILLISECONDS) - -11644473600000000L) * 10L;
    }

    public static final long unixToJavaTime(long utime) {
        return TimeUnit.MILLISECONDS.convert(utime, TimeUnit.SECONDS);
    }

    public static final long javaToUnixTime(long time) {
        return TimeUnit.SECONDS.convert(time, TimeUnit.MILLISECONDS);
    }

    private static boolean isRegexMeta(char c) {
        return regexMetaChars.indexOf(c) != -1;
    }

    private static boolean isGlobMeta(char c) {
        return globMetaChars.indexOf(c) != -1;
    }

    private static char next(String glob, int i) {
        if (i < glob.length()) {
            return glob.charAt(i);
        }
        return EOL;
    }

    public static String toRegexPattern(String globPattern) {
        boolean inGroup = false;
        StringBuilder regex = new StringBuilder("^");
        int i = 0;
        block10: while (i < globPattern.length()) {
            char c = globPattern.charAt(i++);
            switch (c) {
                case '\\': {
                    char next;
                    if (i == globPattern.length()) {
                        throw new PatternSyntaxException("No character to escape", globPattern, i - 1);
                    }
                    if (ZipUtils.isGlobMeta(next = globPattern.charAt(i++)) || ZipUtils.isRegexMeta(next)) {
                        regex.append('\\');
                    }
                    regex.append(next);
                    continue block10;
                }
                case '/': {
                    regex.append(c);
                    continue block10;
                }
                case '[': {
                    regex.append("[[^/]&&[");
                    if (ZipUtils.next(globPattern, i) == '^') {
                        regex.append("\\^");
                        ++i;
                    } else {
                        if (ZipUtils.next(globPattern, i) == '!') {
                            regex.append('^');
                            ++i;
                        }
                        if (ZipUtils.next(globPattern, i) == '-') {
                            regex.append('-');
                            ++i;
                        }
                    }
                    boolean hasRangeStart = false;
                    char last = '\u0000';
                    while (i < globPattern.length() && (c = globPattern.charAt(i++)) != ']') {
                        if (c == '/') {
                            throw new PatternSyntaxException("Explicit 'name separator' in class", globPattern, i - 1);
                        }
                        if (c == '\\' || c == '[' || c == '&' && ZipUtils.next(globPattern, i) == '&') {
                            regex.append('\\');
                        }
                        regex.append(c);
                        if (c == '-') {
                            if (!hasRangeStart) {
                                throw new PatternSyntaxException("Invalid range", globPattern, i - 1);
                            }
                            if ((c = ZipUtils.next(globPattern, i++)) == EOL || c == ']') break;
                            if (c < last) {
                                throw new PatternSyntaxException("Invalid range", globPattern, i - 3);
                            }
                            regex.append(c);
                            hasRangeStart = false;
                            continue;
                        }
                        hasRangeStart = true;
                        last = c;
                    }
                    if (c != ']') {
                        throw new PatternSyntaxException("Missing ']", globPattern, i - 1);
                    }
                    regex.append("]]");
                    continue block10;
                }
                case '{': {
                    if (inGroup) {
                        throw new PatternSyntaxException("Cannot nest groups", globPattern, i - 1);
                    }
                    regex.append("(?:(?:");
                    inGroup = true;
                    continue block10;
                }
                case '}': {
                    if (inGroup) {
                        regex.append("))");
                        inGroup = false;
                        continue block10;
                    }
                    regex.append('}');
                    continue block10;
                }
                case ',': {
                    if (inGroup) {
                        regex.append(")|(?:");
                        continue block10;
                    }
                    regex.append(',');
                    continue block10;
                }
                case '*': {
                    if (ZipUtils.next(globPattern, i) == '*') {
                        regex.append(".*");
                        ++i;
                        continue block10;
                    }
                    regex.append("[^/]*");
                    continue block10;
                }
                case '?': {
                    regex.append("[^/]");
                    continue block10;
                }
            }
            if (ZipUtils.isRegexMeta(c)) {
                regex.append('\\');
            }
            regex.append(c);
        }
        if (inGroup) {
            throw new PatternSyntaxException("Missing '}", globPattern, i - 1);
        }
        return regex.append('$').toString();
    }
}

