/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.AOL;
import com.github.maven_nar.AbstractNarLayout;
import com.github.maven_nar.Javah;
import com.github.maven_nar.Library;
import com.github.maven_nar.Linker;
import com.github.maven_nar.NarConstants;
import com.github.maven_nar.NarInfo;
import com.github.maven_nar.NarLayout;
import com.github.maven_nar.NarUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNarMojo
extends AbstractMojo
implements NarConstants {
    private boolean skip;
    private boolean ignore;
    private String architecture;
    private String os;
    private String aol;
    private Linker linker;
    private File outputDirectory;
    protected File classesDirectory;
    private String output;
    private File baseDir;
    private File targetDirectory;
    private File testTargetDirectory;
    private File unpackDirectory;
    private File testUnpackDirectory;
    protected List<String> classifiers;
    protected List<Library> libraries;
    private String layout;
    private NarLayout narLayout;
    private MavenProject mavenProject;
    private AOL aolId;
    private NarInfo narInfo;
    private Javah javah;
    private File javaHome;

    protected final void validate() throws MojoFailureException, MojoExecutionException {
        this.linker = NarUtil.getLinker(this.linker, this.getLog());
        this.architecture = NarUtil.getArchitecture(this.architecture);
        this.os = NarUtil.getOS(this.os);
        this.aolId = NarUtil.getAOL(this.mavenProject, this.architecture, this.os, this.linker, this.aol, this.getLog());
        Model model = this.mavenProject.getModel();
        Properties properties = model.getProperties();
        properties.setProperty("nar.arch", this.getArchitecture());
        properties.setProperty("nar.os", this.getOS());
        properties.setProperty("nar.linker", this.getLinker().getName());
        properties.setProperty("nar.aol", this.aolId.toString());
        properties.setProperty("nar.aol.key", this.aolId.getKey());
        model.setProperties(properties);
        if (this.targetDirectory == null) {
            this.targetDirectory = new File(this.mavenProject.getBuild().getDirectory(), "nar");
        }
        if (this.testTargetDirectory == null) {
            this.testTargetDirectory = new File(this.mavenProject.getBuild().getDirectory(), "test-nar");
        }
        if (this.unpackDirectory == null) {
            this.unpackDirectory = this.targetDirectory;
        }
        if (this.testUnpackDirectory == null) {
            this.testUnpackDirectory = this.testTargetDirectory;
        }
    }

    protected final String getOutput(boolean versioned) throws MojoExecutionException {
        if (this.output != null && !this.output.trim().isEmpty()) {
            return this.output;
        }
        if (versioned) {
            return this.getMavenProject().getArtifactId() + "-" + this.getMavenProject().getVersion();
        }
        return this.getMavenProject().getArtifactId();
    }

    protected final String getArchitecture() {
        return this.architecture;
    }

    protected final String getOS() {
        return this.os;
    }

    protected final AOL getAOL() throws MojoFailureException, MojoExecutionException {
        return this.aolId;
    }

    protected final Linker getLinker() {
        return this.linker;
    }

    protected final File getBasedir() {
        return this.baseDir;
    }

    protected final File getOutputDirectory() {
        return this.outputDirectory;
    }

    protected final File getTargetDirectory() {
        return this.targetDirectory;
    }

    protected final File getTestTargetDirectory() {
        return this.testTargetDirectory;
    }

    protected File getUnpackDirectory() {
        return this.unpackDirectory;
    }

    protected final File getTestUnpackDirectory() {
        return this.testUnpackDirectory;
    }

    protected final NarLayout getLayout() throws MojoExecutionException {
        if (this.narLayout == null) {
            this.narLayout = AbstractNarLayout.getLayout(this.layout, this.getLog());
        }
        return this.narLayout;
    }

    protected final MavenProject getMavenProject() {
        return this.mavenProject;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)(this.getClass().getName() + " skipped"));
            return;
        }
        try {
            this.validate();
            this.narExecute();
        }
        catch (MojoFailureException mfe) {
            if (this.ignore) {
                this.getLog().warn((CharSequence)("IGNORED: " + mfe.getMessage()));
            }
            throw mfe;
        }
        catch (MojoExecutionException mee) {
            if (this.ignore) {
                this.getLog().warn((CharSequence)("IGNORED: " + mee.getMessage()));
            }
            throw mee;
        }
    }

    public abstract void narExecute() throws MojoFailureException, MojoExecutionException;

    protected NarInfo getNarInfo() throws MojoExecutionException {
        if (this.narInfo == null) {
            String groupId = this.getMavenProject().getGroupId();
            String artifactId = this.getMavenProject().getArtifactId();
            String path = "META-INF/nar/" + groupId + "/" + artifactId + "/" + "nar.properties";
            File propertiesFile = new File(this.classesDirectory, path);
            if (!propertiesFile.exists()) {
                propertiesFile = new File(this.getMavenProject().getBasedir(), "src/main/resources/" + path);
            }
            this.narInfo = new NarInfo(groupId, artifactId, this.getMavenProject().getVersion(), this.getLog(), propertiesFile);
        }
        return this.narInfo;
    }

    protected final List<Library> getLibraries() {
        if (this.libraries == null) {
            this.libraries = Collections.EMPTY_LIST;
        }
        return this.libraries;
    }

    protected final Javah getJavah() {
        if (this.javah == null) {
            this.javah = new Javah();
        }
        this.javah.setAbstractCompileMojo(this);
        return this.javah;
    }

    protected final File getJavaHome(AOL aol) throws MojoExecutionException {
        return this.getNarInfo().getProperty(aol, "javaHome", NarUtil.getJavaHome(this.javaHome, this.getOS()));
    }
}

