/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.AOL;
import com.github.maven_nar.AbstractCompileMojo;
import com.github.maven_nar.Compiler;
import com.github.maven_nar.Library;
import com.github.maven_nar.NarArtifact;
import com.github.maven_nar.NarUtil;
import com.github.maven_nar.cpptasks.CCTask;
import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.CompilerDef;
import com.github.maven_nar.cpptasks.LinkerDef;
import com.github.maven_nar.cpptasks.OutputTypeEnum;
import com.github.maven_nar.cpptasks.RuntimeType;
import com.github.maven_nar.cpptasks.SubsystemEnum;
import com.github.maven_nar.cpptasks.types.LibrarySet;
import com.github.maven_nar.cpptasks.types.LinkerArgument;
import com.github.maven_nar.cpptasks.types.SystemLibrarySet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class NarCompileMojo
extends AbstractCompileMojo {
    protected MavenSession session;

    protected List getArtifacts() {
        return this.getMavenProject().getCompileArtifacts();
    }

    private void copyInclude(Compiler c) throws IOException, MojoExecutionException, MojoFailureException {
        if (c == null) {
            return;
        }
        c.copyIncludeFiles(this.getMavenProject(), this.getLayout().getIncludeDirectory(this.getTargetDirectory(), this.getMavenProject().getArtifactId(), this.getMavenProject().getVersion()));
    }

    public final void narExecute() throws MojoExecutionException, MojoFailureException {
        super.narExecute();
        this.getTargetDirectory().mkdirs();
        int noOfSources = 0;
        noOfSources += this.getSourcesFor(this.getCpp()).size();
        noOfSources += this.getSourcesFor(this.getC()).size();
        if ((noOfSources += this.getSourcesFor(this.getFortran()).size()) > 0) {
            this.getLog().info((CharSequence)("Compiling " + noOfSources + " native files"));
            Iterator<Library> i = this.getLibraries().iterator();
            while (i.hasNext()) {
                this.createLibrary(this.getAntProject(), i.next());
            }
        } else {
            this.getLog().info((CharSequence)"Nothing to compile");
        }
        try {
            this.copyInclude(this.getCpp());
            this.copyInclude(this.getC());
            this.copyInclude(this.getFortran());
        }
        catch (IOException e) {
            throw new MojoExecutionException("NAR: could not copy include files", (Exception)e);
        }
        this.getNarInfo().writeToDirectory(this.classesDirectory);
    }

    private List getSourcesFor(Compiler compiler) throws MojoFailureException, MojoExecutionException {
        if (compiler == null) {
            return Collections.EMPTY_LIST;
        }
        try {
            ArrayList files = new ArrayList();
            List srcDirs = compiler.getSourceDirectories();
            for (File dir : srcDirs) {
                if (!dir.exists()) continue;
                files.addAll(FileUtils.getFiles((File)dir, (String)StringUtils.join(compiler.getIncludes().iterator(), (String)","), null));
            }
            return files;
        }
        catch (IOException e) {
            return Collections.EMPTY_LIST;
        }
    }

    private void createLibrary(Project antProject, Library library) throws MojoExecutionException, MojoFailureException {
        File jniDirectory;
        CompilerDef fortran;
        CompilerDef c;
        CompilerDef cpp;
        CompilerDef res;
        CompilerDef mc;
        CompilerDef idl;
        this.getLog().debug((CharSequence)("Creating Library " + library));
        CCTask task = new CCTask();
        task.setCommandLogLevel(this.commandLogLevel);
        task.setProject(antProject);
        task.setDecorateLinkerOptions(this.decorateLinkerOptions);
        task.setDecorateLinkerOptions(this.decorateLinkerOptions);
        SubsystemEnum subSystem = new SubsystemEnum();
        subSystem.setValue(library.getSubSystem());
        task.setSubsystem(subSystem);
        task.setMaxCores(this.getMaxCores(this.getAOL()));
        OutputTypeEnum outTypeEnum = new OutputTypeEnum();
        String type = library.getType();
        outTypeEnum.setValue(type);
        task.setOuttype(outTypeEnum);
        task.setLinkCPP(library.linkCPP());
        task.setLinkFortran(library.linkFortran());
        task.setLinkFortranMain(library.linkFortranMain());
        File outDir = type.equals("executable") ? this.getLayout().getBinDirectory(this.getTargetDirectory(), this.getMavenProject().getArtifactId(), this.getMavenProject().getVersion(), this.getAOL().toString()) : this.getLayout().getLibDirectory(this.getTargetDirectory(), this.getMavenProject().getArtifactId(), this.getMavenProject().getVersion(), this.getAOL().toString(), type);
        outDir.mkdirs();
        File outFile = new File(outDir, this.getOutput(this.getAOL(), type));
        this.getLog().debug((CharSequence)("NAR - output: '" + outFile + "'"));
        task.setOutfile(outFile);
        File objDir = new File(this.getTargetDirectory(), "obj");
        objDir = new File(objDir, this.getAOL().toString());
        objDir.mkdirs();
        task.setObjdir(objDir);
        task.setFailonerror(this.failOnError(this.getAOL()));
        task.setLibtool(this.useLibtool(this.getAOL()));
        RuntimeType runtimeType = new RuntimeType();
        runtimeType.setValue(this.getRuntime(this.getAOL()));
        task.setRuntime(runtimeType);
        if (this.getIdl() != null && (idl = this.getIdl().getCompiler("main", null)) != null) {
            task.addConfiguredCompiler(idl);
        }
        if (this.getMessage() != null && (mc = this.getMessage().getCompiler("main", null)) != null) {
            task.addConfiguredCompiler(mc);
        }
        if (this.getResource() != null && (res = this.getResource().getCompiler("main", null)) != null) {
            task.addConfiguredCompiler(res);
        }
        if (this.getCpp() != null && (cpp = this.getCpp().getCompiler("main", null)) != null) {
            task.addConfiguredCompiler(cpp);
        }
        if (this.getC() != null && (c = this.getC().getCompiler("main", null)) != null) {
            task.addConfiguredCompiler(c);
        }
        if (this.getFortran() != null && (fortran = this.getFortran().getCompiler("main", null)) != null) {
            task.addConfiguredCompiler(fortran);
        }
        if ((jniDirectory = this.getJavah().getJniDirectory()).exists()) {
            task.createIncludePath().setPath(jniDirectory.getPath());
        }
        this.getJava().addIncludePaths(task, type);
        List<NarArtifact> dependencies = this.getNarArtifacts();
        for (NarArtifact narDependency : dependencies) {
            String binding = narDependency.getNarInfo().getBinding(this.getAOL(), "static");
            this.getLog().debug((CharSequence)("Looking for " + (Object)((Object)narDependency) + " found binding " + binding));
            if (binding.equals("jni")) continue;
            File unpackDirectory = this.getUnpackDirectory();
            File include = this.getLayout().getIncludeDirectory(unpackDirectory, narDependency.getArtifactId(), narDependency.getVersion());
            this.getLog().debug((CharSequence)("Looking for include directory: " + include));
            if (include.exists()) {
                task.createIncludePath().setPath(include.getPath());
                continue;
            }
            throw new MojoExecutionException("NAR: unable to locate include path: " + include);
        }
        LinkerDef linkerDefinition = this.getLinker().getLinker(this, antProject, this.getOS(), this.getAOL().getKey() + ".linker.", type);
        task.addConfiguredLinker(linkerDefinition);
        if (type.equals("shared") || type.equals("jni") || type.equals("executable")) {
            List depLibOrder = this.getDependencyLibOrder();
            List<NarArtifact> depLibs = dependencies;
            if (depLibOrder != null && !depLibOrder.isEmpty()) {
                LinkedList<NarArtifact> tmp = new LinkedList<NarArtifact>();
                for (String depToOrderName : depLibOrder) {
                    Iterator<NarArtifact> j = depLibs.iterator();
                    while (j.hasNext()) {
                        NarArtifact dep = j.next();
                        String depName = dep.getGroupId() + ":" + dep.getArtifactId();
                        if (!depName.equals(depToOrderName)) continue;
                        tmp.add(dep);
                        j.remove();
                    }
                }
                tmp.addAll(depLibs);
                depLibs = tmp;
            }
            for (NarArtifact dependency : depLibs) {
                String sysLibs;
                String binding = dependency.getNarInfo().getBinding(this.getAOL(), "none");
                this.getLog().debug((CharSequence)("Using Binding: " + binding));
                AOL aol = this.getAOL();
                aol = dependency.getNarInfo().getAOL(this.getAOL());
                this.getLog().debug((CharSequence)("Using Library AOL: " + aol.toString()));
                if (binding.equals("jni") || binding.equals("none") || binding.equals("executable")) continue;
                File unpackDirectory = this.getUnpackDirectory();
                File dir = this.getLayout().getLibDirectory(unpackDirectory, dependency.getArtifactId(), dependency.getVersion(), aol.toString(), binding);
                this.getLog().debug((CharSequence)("Looking for Library Directory: " + dir));
                if (dir.exists()) {
                    LibrarySet libSet = new LibrarySet();
                    libSet.setProject(antProject);
                    String libs = dependency.getNarInfo().getLibs(this.getAOL());
                    if (libs != null && !libs.equals("")) {
                        this.getLog().debug((CharSequence)("Using LIBS = " + libs));
                        libSet.setLibs(new CUtil.StringArrayBuilder(libs));
                        libSet.setDir(dir);
                        task.addLibset(libSet);
                    }
                } else {
                    this.getLog().debug((CharSequence)("Library Directory " + dir + " does NOT exist."));
                }
                String options = dependency.getNarInfo().getOptions(this.getAOL());
                if (options != null && !options.equals("")) {
                    this.getLog().debug((CharSequence)("Using OPTIONS = " + options));
                    LinkerArgument arg = new LinkerArgument();
                    arg.setValue(options);
                    linkerDefinition.addConfiguredLinkerArg(arg);
                }
                if ((sysLibs = dependency.getNarInfo().getSysLibs(this.getAOL())) == null || sysLibs.equals("")) continue;
                this.getLog().debug((CharSequence)("Using SYSLIBS = " + sysLibs));
                SystemLibrarySet sysLibSet = new SystemLibrarySet();
                sysLibSet.setProject(antProject);
                sysLibSet.setLibs(new CUtil.StringArrayBuilder(sysLibs));
                task.addSyslibset(sysLibSet);
            }
        }
        this.getJava().addRuntime(task, this.getJavaHome(this.getAOL()), this.getOS(), this.getAOL().getKey() + ".java.");
        try {
            task.execute();
        }
        catch (BuildException e) {
            throw new MojoExecutionException("NAR: Compile failed", (Exception)((Object)e));
        }
        if (this.getRuntime(this.getAOL()).equals("dynamic") && this.getOS().equals("Windows") && this.getLinker().getName(null, null).equals("msvc") && !this.getLinker().getVersion().startsWith("6.")) {
            String exe;
            int result;
            String manifest;
            String libType = library.getType();
            if (libType.equals("jni") || libType.equals("shared")) {
                String dll = outFile.getPath() + ".dll";
                manifest = dll + ".manifest";
                int result2 = NarUtil.runCommand("mt.exe", new String[]{"/manifest", manifest, "/outputresource:" + dll + ";#2"}, null, null, this.getLog());
                if (result2 != 0) {
                    throw new MojoFailureException("MT.EXE failed with exit code: " + result2);
                }
            } else if (libType.equals("executable") && (result = NarUtil.runCommand("mt.exe", new String[]{"/manifest", manifest = (exe = outFile.getPath() + ".exe") + ".manifest", "/outputresource:" + exe + ";#1"}, null, null, this.getLog())) != 0) {
                throw new MojoFailureException("MT.EXE failed with exit code: " + result);
            }
        }
    }
}

