/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.AbstractDependencyMojo;
import com.github.maven_nar.Library;
import com.github.maven_nar.NarArtifact;
import com.github.maven_nar.NarUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.surefire.booter.ForkConfiguration;
import org.apache.maven.surefire.booter.SurefireBooter;
import org.apache.maven.surefire.booter.SurefireBooterForkException;
import org.apache.maven.surefire.booter.SurefireExecutionException;
import org.apache.maven.surefire.report.BriefConsoleReporter;
import org.apache.maven.surefire.report.BriefFileReporter;
import org.apache.maven.surefire.report.ConsoleReporter;
import org.apache.maven.surefire.report.DetailedConsoleReporter;
import org.apache.maven.surefire.report.FileReporter;
import org.apache.maven.surefire.report.ForkingConsoleReporter;
import org.apache.maven.surefire.report.XMLReporter;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.StringUtils;

public class NarIntegrationTestMojo
extends AbstractDependencyMojo {
    private boolean skipNar;
    private boolean skipNarTests;
    private boolean skipNarExec;
    private boolean testFailureIgnore;
    private File basedir;
    private File testClassesDirectory;
    private File classesDirectory;
    private MavenProject project;
    private List classpathElements;
    private List additionalClasspathElements;
    private File reportsDirectory;
    private File testSourceDirectory;
    private String test;
    private List includes;
    private List excludes;
    private Properties systemProperties;
    private Properties properties;
    private Map pluginArtifactMap;
    private Map projectArtifactMap;
    private boolean printSummary;
    private String reportFormat;
    private boolean useFile;
    private boolean redirectTestOutputToFile;
    private Boolean failIfNoTests;
    private String forkMode;
    private String jvm;
    private String argLine;
    private String debugForkedProcess;
    private int forkedProcessTimeoutInSeconds;
    private Map environmentVariables = new HashMap();
    private File workingDirectory;
    private boolean childDelegation;
    private String groups;
    private String excludedGroups;
    private File[] suiteXmlFiles;
    private String junitArtifactName;
    private String testNGArtifactName;
    private int threadCount;
    private String parallel;
    private boolean trimStackTrace;
    private ArtifactFactory artifactFactory;
    private ArtifactMetadataSource metadataSource;
    private static final String BRIEF_REPORT_FORMAT = "brief";
    private static final String PLAIN_REPORT_FORMAT = "plain";
    private Properties originalSystemProperties;
    private boolean disableXmlReport;
    private Boolean useSystemClassLoader;
    private boolean useManifestOnlyJar;
    private boolean enableAssertions;
    private MavenSession session;

    protected List getArtifacts() {
        return this.getMavenProject().getTestArtifacts();
    }

    protected File getUnpackDirectory() {
        return this.getTestUnpackDirectory() == null ? super.getUnpackDirectory() : this.getTestUnpackDirectory();
    }

    private boolean testJNIModule() {
        for (Library lib : this.getLibraries()) {
            String type = lib.getType();
            if (!type.equals("jni") && !type.equals("shared")) continue;
            return true;
        }
        return false;
    }

    public void narExecute() throws MojoExecutionException, MojoFailureException {
        if (this.verifyParameters()) {
            int result;
            super.narExecute();
            SurefireBooter surefireBooter = this.constructSurefireBooter();
            this.getLog().info((CharSequence)("Surefire report directory: " + this.reportsDirectory));
            try {
                result = surefireBooter.run();
            }
            catch (SurefireBooterForkException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
            catch (SurefireExecutionException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
            if (this.originalSystemProperties != null && !surefireBooter.isForking()) {
                System.setProperties(this.originalSystemProperties);
            }
            if (result == 0) {
                return;
            }
            if (result == 254) {
                if (this.failIfNoTests == null || !this.failIfNoTests.booleanValue()) {
                    return;
                }
                throw new MojoFailureException("No tests were executed!  (Set -DfailIfNoTests=false to ignore this error.)");
            }
            String msg = "There are test failures.\n\nPlease refer to " + this.reportsDirectory + " for the individual test results.";
            if (this.testFailureIgnore) {
                this.getLog().error((CharSequence)msg);
            } else {
                throw new MojoFailureException(msg);
            }
        }
    }

    private boolean verifyParameters() throws MojoFailureException {
        if (this.skipNar || this.skipNarTests || this.skipNarExec) {
            this.getLog().info((CharSequence)"Tests are skipped.");
            return false;
        }
        if (!this.testClassesDirectory.exists()) {
            if (this.failIfNoTests != null && this.failIfNoTests.booleanValue()) {
                throw new MojoFailureException("No tests to run!");
            }
            this.getLog().info((CharSequence)"No tests to run.");
            return false;
        }
        if (this.useSystemClassLoader != null && "never".equals(this.forkMode)) {
            this.getLog().warn((CharSequence)"useSystemClassloader setting has no effect when not forking");
        }
        return true;
    }

    private void convertTestNGParameters() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        if (this.parallel != null) {
            this.properties.setProperty("parallel", this.parallel);
        }
        if (this.excludedGroups != null) {
            this.properties.setProperty("excludegroups", this.excludedGroups);
        }
        if (this.groups != null) {
            this.properties.setProperty("groups", this.groups);
        }
        if (this.threadCount > 0) {
            this.properties.setProperty("threadcount", new Integer(this.threadCount).toString());
        }
    }

    private SurefireBooter constructSurefireBooter() throws MojoExecutionException, MojoFailureException {
        Artifact testNgArtifact;
        Artifact junitArtifact;
        SurefireBooter surefireBooter = new SurefireBooter();
        Artifact surefireArtifact = (Artifact)this.pluginArtifactMap.get("org.apache.maven.surefire:surefire-booter");
        if (surefireArtifact == null) {
            throw new MojoExecutionException("Unable to locate surefire-booter in the list of plugin artifacts");
        }
        surefireArtifact.isSnapshot();
        try {
            this.addArtifact(surefireBooter, surefireArtifact);
            junitArtifact = (Artifact)this.projectArtifactMap.get(this.junitArtifactName);
            if (junitArtifact == null && "junit:junit".equals(this.junitArtifactName)) {
                junitArtifact = (Artifact)this.projectArtifactMap.get("junit:junit-dep");
            }
            if ((testNgArtifact = (Artifact)this.projectArtifactMap.get(this.testNGArtifactName)) != null) {
                VersionRange range = VersionRange.createFromVersionSpec((String)"[4.7,)");
                if (!range.containsVersion((ArtifactVersion)new DefaultArtifactVersion(testNgArtifact.getVersion()))) {
                    throw new MojoFailureException("TestNG support requires version 4.7 or above. You have declared version " + testNgArtifact.getVersion());
                }
                this.convertTestNGParameters();
                if (this.testClassesDirectory != null) {
                    this.properties.setProperty("testng.test.classpath", this.testClassesDirectory.getAbsolutePath());
                }
                this.addArtifact(surefireBooter, testNgArtifact);
                this.addProvider(surefireBooter, "surefire-testng", surefireArtifact.getBaseVersion(), testNgArtifact);
            } else if (junitArtifact != null && junitArtifact.getBaseVersion().startsWith("4")) {
                this.addProvider(surefireBooter, "surefire-junit4", surefireArtifact.getBaseVersion(), null);
            } else {
                this.addProvider(surefireBooter, "surefire-junit", surefireArtifact.getBaseVersion(), null);
            }
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Unable to locate required surefire provider dependency: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException("Error determining the TestNG version requested: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Error to resolving surefire provider dependency: " + e.getMessage(), (Exception)((Object)e));
        }
        if (this.suiteXmlFiles != null && this.suiteXmlFiles.length > 0 && this.test == null) {
            if (testNgArtifact == null) {
                throw new MojoExecutionException("suiteXmlFiles is configured, but there is no TestNG dependency");
            }
            surefireBooter.addTestSuite("org.apache.maven.surefire.testng.TestNGXmlTestSuite", new Object[]{this.suiteXmlFiles, this.testSourceDirectory.getAbsolutePath(), testNgArtifact.getVersion(), testNgArtifact.getClassifier(), this.properties, this.reportsDirectory});
        } else {
            ArrayList<Object> excludeList;
            ArrayList<Object> includeList;
            if (this.test != null) {
                includeList = new ArrayList();
                excludeList = new ArrayList();
                if (this.failIfNoTests == null) {
                    this.failIfNoTests = Boolean.TRUE;
                }
                String[] testRegexes = StringUtils.split((String)this.test, (String)",");
                for (int i = 0; i < testRegexes.length; ++i) {
                    String testRegex = testRegexes[i];
                    if (testRegex.endsWith(".java")) {
                        testRegex = testRegex.substring(0, testRegex.length() - 5);
                    }
                    testRegex = testRegex.replace('.', '/');
                    includeList.add("**/" + testRegex + ".java");
                }
            } else {
                includeList = this.includes;
                excludeList = this.excludes;
                if (includeList == null || includeList.size() == 0) {
                    includeList = new ArrayList<String>(Arrays.asList("**/Test*.java", "**/*Test.java", "**/*TestCase.java"));
                }
                if (excludeList == null || excludeList.size() == 0) {
                    excludeList = new ArrayList<String>(Arrays.asList("**/*$*"));
                }
            }
            if (testNgArtifact != null) {
                surefireBooter.addTestSuite("org.apache.maven.surefire.testng.TestNGDirectoryTestSuite", new Object[]{this.testClassesDirectory, includeList, excludeList, this.testSourceDirectory.getAbsolutePath(), testNgArtifact.getVersion(), testNgArtifact.getClassifier(), this.properties, this.reportsDirectory});
            } else {
                String junitDirectoryTestSuite = junitArtifact != null && junitArtifact.getBaseVersion() != null && junitArtifact.getBaseVersion().startsWith("4") ? "org.apache.maven.surefire.junit4.JUnit4DirectoryTestSuite" : "org.apache.maven.surefire.junit.JUnitDirectoryTestSuite";
                surefireBooter.addTestSuite(junitDirectoryTestSuite, new Object[]{this.testClassesDirectory, includeList, excludeList});
            }
        }
        this.getLog().debug((CharSequence)"Test Classpath :");
        if (!this.project.getBuild().getOutputDirectory().equals(this.classesDirectory.getAbsolutePath())) {
            this.classpathElements.remove(this.project.getBuild().getOutputDirectory());
            this.classpathElements.add(this.classesDirectory.getAbsolutePath());
        }
        if (!this.project.getBuild().getTestOutputDirectory().equals(this.testClassesDirectory.getAbsolutePath())) {
            this.classpathElements.remove(this.project.getBuild().getTestOutputDirectory());
            this.classpathElements.add(this.testClassesDirectory.getAbsolutePath());
        }
        for (String classpathElement : this.classpathElements) {
            this.getLog().debug((CharSequence)("  " + classpathElement));
            surefireBooter.addClassPathUrl(classpathElement);
        }
        Toolchain tc = this.getToolchain();
        if (tc != null) {
            this.getLog().info((CharSequence)("Toolchain in surefire-plugin: " + tc));
            if ("never".equals(this.forkMode)) {
                this.forkMode = "once";
            }
            if (this.jvm != null) {
                this.getLog().warn((CharSequence)("Toolchains are ignored, 'executable' parameter is set to " + this.jvm));
            } else {
                this.jvm = tc.findTool("java");
            }
        }
        if (this.additionalClasspathElements != null) {
            for (String classpathElement : this.additionalClasspathElements) {
                this.getLog().debug((CharSequence)("  " + classpathElement));
                surefireBooter.addClassPathUrl(classpathElement);
            }
        }
        ForkConfiguration fork = new ForkConfiguration();
        if (this.project.getPackaging().equals("nar") || this.getNarArtifacts().size() > 0) {
            this.forkMode = "pertest";
        }
        fork.setForkMode(this.forkMode);
        this.processSystemProperties(!fork.isForking());
        if (this.getLog().isDebugEnabled()) {
            this.showMap(this.systemProperties, "system property");
        }
        if (fork.isForking()) {
            List<String> args;
            this.useSystemClassLoader = this.useSystemClassLoader == null ? Boolean.TRUE : this.useSystemClassLoader;
            fork.setUseSystemClassLoader(this.useSystemClassLoader.booleanValue());
            fork.setUseManifestOnlyJar(this.useManifestOnlyJar);
            fork.setSystemProperties(this.systemProperties);
            if ("true".equals(this.debugForkedProcess)) {
                this.debugForkedProcess = "-Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=5005";
            }
            fork.setDebugLine(this.debugForkedProcess);
            if (this.jvm == null || "".equals(this.jvm)) {
                this.jvm = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
                this.getLog().debug((CharSequence)("Using JVM: " + this.jvm));
            }
            fork.setJvmExecutable(this.jvm);
            if (this.workingDirectory != null) {
                fork.setWorkingDirectory(this.workingDirectory);
            } else {
                fork.setWorkingDirectory(this.basedir);
            }
            if (this.argLine == null) {
                this.argLine = "";
            }
            StringBuffer javaLibraryPath = new StringBuffer();
            if (this.testJNIModule()) {
                File sharedLibraryPathEntry;
                File jniLibraryPathEntry = this.getLayout().getLibDirectory(this.getTargetDirectory(), this.getMavenProject().getArtifactId(), this.getMavenProject().getVersion(), this.getAOL().toString(), "jni");
                if (jniLibraryPathEntry.exists()) {
                    this.getLog().debug((CharSequence)("Adding library directory to java.library.path: " + jniLibraryPathEntry));
                    if (javaLibraryPath.length() > 0) {
                        javaLibraryPath.append(File.pathSeparator);
                    }
                    javaLibraryPath.append(jniLibraryPathEntry);
                }
                if ((sharedLibraryPathEntry = this.getLayout().getLibDirectory(this.getTargetDirectory(), this.getMavenProject().getArtifactId(), this.getMavenProject().getVersion(), this.getAOL().toString(), "shared")).exists()) {
                    this.getLog().debug((CharSequence)("Adding library directory to java.library.path: " + sharedLibraryPathEntry));
                    if (javaLibraryPath.length() > 0) {
                        javaLibraryPath.append(File.pathSeparator);
                    }
                    javaLibraryPath.append(sharedLibraryPathEntry);
                }
                String narFile = "target/" + this.project.getArtifactId() + "-" + this.project.getVersion() + ".jar";
                this.getLog().debug((CharSequence)("Adding to surefire test classpath: " + narFile));
                surefireBooter.addClassPathUrl(narFile);
            }
            List<NarArtifact> dependencies = this.getNarArtifacts();
            for (NarArtifact dependency : dependencies) {
                String[] bindings = new String[]{"shared", "jni"};
                for (int j = 0; j < bindings.length; ++j) {
                    File depLibPathEntry;
                    String binding = bindings[j];
                    if (binding.equals("static") || !(depLibPathEntry = this.getLayout().getLibDirectory(this.getUnpackDirectory(), dependency.getArtifactId(), dependency.getVersion(), this.getAOL().toString(), binding)).exists()) continue;
                    this.getLog().debug((CharSequence)("Adding dependency directory to java.library.path: " + depLibPathEntry));
                    if (javaLibraryPath.length() > 0) {
                        javaLibraryPath.append(File.pathSeparator);
                    }
                    javaLibraryPath.append(depLibPathEntry);
                }
            }
            if (javaLibraryPath.length() > 0) {
                NarUtil.addLibraryPathToEnv(javaLibraryPath.toString(), this.environmentVariables, this.getOS());
            }
            if (this.getOS().equals("Windows")) {
                this.environmentVariables.put("SystemRoot", NarUtil.getEnv("SystemRoot", "SystemRoot", "C:\\Windows"));
            }
            fork.setArgLine(this.argLine);
            fork.setEnvironmentVariables(this.environmentVariables);
            if (this.getLog().isDebugEnabled()) {
                this.showMap(this.environmentVariables, "environment variable");
                fork.setDebug(true);
            }
            if (this.argLine != null && ((args = Arrays.asList(this.argLine.split(" "))).contains("-da") || args.contains("-disableassertions"))) {
                this.enableAssertions = false;
            }
        }
        surefireBooter.setFailIfNoTests(this.failIfNoTests == null ? false : this.failIfNoTests);
        surefireBooter.setForkedProcessTimeoutInSeconds(this.forkedProcessTimeoutInSeconds);
        surefireBooter.setRedirectTestOutputToFile(this.redirectTestOutputToFile);
        surefireBooter.setForkConfiguration(fork);
        surefireBooter.setChildDelegation(this.childDelegation);
        surefireBooter.setEnableAssertions(this.enableAssertions);
        surefireBooter.setReportsDirectory(this.reportsDirectory);
        this.addReporters(surefireBooter, fork.isForking());
        return surefireBooter;
    }

    private void showMap(Map map, String setting) {
        for (String key : map.keySet()) {
            String value = (String)map.get(key);
            this.getLog().debug((CharSequence)("Setting " + setting + " [" + key + "]=[" + value + "]"));
        }
    }

    private void addProvider(SurefireBooter surefireBooter, String provider, String version, Artifact filteredArtifact) throws ArtifactNotFoundException, ArtifactResolutionException {
        Artifact providerArtifact = this.artifactFactory.createDependencyArtifact("org.apache.maven.surefire", provider, VersionRange.createFromVersion((String)version), "jar", null, "test");
        ArtifactResolutionResult result = this.resolveArtifact(filteredArtifact, providerArtifact);
        for (Artifact artifact : result.getArtifacts()) {
            this.getLog().debug((CharSequence)("Adding to surefire test classpath: " + artifact.getFile().getAbsolutePath()));
            surefireBooter.addSurefireClassPathUrl(artifact.getFile().getAbsolutePath());
        }
    }

    private ArtifactResolutionResult resolveArtifact(Artifact filteredArtifact, Artifact providerArtifact) throws ArtifactResolutionException, ArtifactNotFoundException {
        ExcludesArtifactFilter filter = null;
        if (filteredArtifact != null) {
            filter = new ExcludesArtifactFilter(Collections.singletonList(filteredArtifact.getGroupId() + ":" + filteredArtifact.getArtifactId()));
        }
        Artifact originatingArtifact = this.artifactFactory.createBuildArtifact("dummy", "dummy", "1.0", "jar");
        return this.artifactResolver.resolveTransitively(Collections.singleton(providerArtifact), originatingArtifact, this.getLocalRepository(), this.getRemoteRepositories(), this.metadataSource, (ArtifactFilter)filter);
    }

    private void addArtifact(SurefireBooter surefireBooter, Artifact surefireArtifact) throws ArtifactNotFoundException, ArtifactResolutionException {
        ArtifactResolutionResult result = this.resolveArtifact(null, surefireArtifact);
        for (Artifact artifact : result.getArtifacts()) {
            this.getLog().debug((CharSequence)("Adding to surefire booter test classpath: " + artifact.getFile().getAbsolutePath()));
            surefireBooter.addSurefireBootClassPathUrl(artifact.getFile().getAbsolutePath());
        }
    }

    protected void processSystemProperties(boolean setInSystem) {
        if (this.systemProperties == null) {
            this.systemProperties = new Properties();
        }
        this.originalSystemProperties = (Properties)System.getProperties().clone();
        Properties userSpecifiedProperties = (Properties)this.session.getExecutionProperties().clone();
        userSpecifiedProperties.putAll((Map<?, ?>)this.systemProperties);
        this.systemProperties.setProperty("basedir", this.basedir.getAbsolutePath());
        this.systemProperties.setProperty("user.dir", this.workingDirectory.getAbsolutePath());
        this.systemProperties.setProperty("localRepository", this.getLocalRepository().getBasedir());
        if (setInSystem) {
            for (String string : this.systemProperties.keySet()) {
                String value = this.systemProperties.getProperty(string);
                System.setProperty(string, value);
            }
        }
    }

    private void addReporters(SurefireBooter surefireBooter, boolean forking) {
        Boolean trimStackTrace = this.trimStackTrace;
        if (this.useFile) {
            if (this.printSummary) {
                if (forking) {
                    surefireBooter.addReport(ForkingConsoleReporter.class.getName(), new Object[]{trimStackTrace});
                } else {
                    surefireBooter.addReport(ConsoleReporter.class.getName(), new Object[]{trimStackTrace});
                }
            }
            if (BRIEF_REPORT_FORMAT.equals(this.reportFormat)) {
                surefireBooter.addReport(BriefFileReporter.class.getName(), new Object[]{this.reportsDirectory, trimStackTrace});
            } else if (PLAIN_REPORT_FORMAT.equals(this.reportFormat)) {
                surefireBooter.addReport(FileReporter.class.getName(), new Object[]{this.reportsDirectory, trimStackTrace});
            }
        } else if (BRIEF_REPORT_FORMAT.equals(this.reportFormat)) {
            surefireBooter.addReport(BriefConsoleReporter.class.getName(), new Object[]{trimStackTrace});
        } else if (PLAIN_REPORT_FORMAT.equals(this.reportFormat)) {
            surefireBooter.addReport(DetailedConsoleReporter.class.getName(), new Object[]{trimStackTrace});
        }
        if (!this.disableXmlReport) {
            surefireBooter.addReport(XMLReporter.class.getName(), new Object[]{this.reportsDirectory, trimStackTrace});
        }
    }

    public boolean isSkipExec() {
        return this.skipNarTests;
    }

    public void setSkipExec(boolean skipExec) {
        this.skipNarTests = skipExec;
    }

    private Toolchain getToolchain() {
        Toolchain tc = null;
        try {
            ToolchainManager toolchainManager;
            if (this.session != null && (toolchainManager = (ToolchainManager)this.session.getContainer().lookup(ToolchainManager.ROLE)) != null) {
                tc = toolchainManager.getToolchainFromBuildContext("jdk", this.session);
            }
        }
        catch (ComponentLookupException componentLookupException) {
            // empty catch block
        }
        return tc;
    }
}

