/*
 * Decompiled with CFR 0.152.
 */
package com.github.parboiled1.grappa.buffers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import java.nio.CharBuffer;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.Tainted;
import org.parboiled.support.Position;

@ParametersAreNonnullByDefault
public final class LineCounter {
    private final List<Range<Integer>> lines = Lists.newArrayList();
    private final int nrLines;
    private final int len;

    public LineCounter(CharSequence input) {
        int lowerBound = 0;
        int index = 0;
        this.len = input.length();
        while (index < this.len) {
            if (input.charAt(index++) != '\n') continue;
            this.lines.add((Range<Integer>)Range.closedOpen((Comparable)Integer.valueOf(lowerBound), (Comparable)Integer.valueOf(index)));
            lowerBound = index;
        }
        this.lines.add((Range<Integer>)Range.closedOpen((Comparable)Integer.valueOf(lowerBound), (Comparable)Integer.valueOf(index)));
        this.nrLines = this.lines.size();
    }

    public LineCounter(char[] chars) {
        this(CharBuffer.wrap(chars));
    }

    @VisibleForTesting
    LineCounter(List<Range<Integer>> ranges) {
        this.lines.addAll(ranges);
        this.nrLines = ranges.size();
        this.len = (Integer)ranges.get(this.nrLines - 1).upperEndpoint();
    }

    public int getNrLines() {
        return this.nrLines;
    }

    public Range<Integer> getLineRange(@Tainted int lineNr) {
        return this.lines.get(Math.min(lineNr, this.nrLines) - 1);
    }

    public Position toPosition(@Tainted int index) {
        if (index < 0) {
            throw new IllegalStateException();
        }
        if (index >= this.len) {
            Range<Integer> range = this.lines.get(this.nrLines - 1);
            return new Position(this.nrLines, this.len - (Integer)range.lowerEndpoint() + 1);
        }
        int lineNr = this.binarySearch(index);
        Range<Integer> range = this.lines.get(lineNr);
        return new Position(lineNr + 1, index - (Integer)range.lowerEndpoint() + 1);
    }

    @VisibleForTesting
    int binarySearch(int index) {
        return this.doBinarySearch(0, this.nrLines - 1, index);
    }

    private int doBinarySearch(int low, int high, int index) {
        if (high - low <= 1) {
            return this.lines.get(low).contains((Comparable)Integer.valueOf(index)) ? low : high;
        }
        int middle = (low + high) / 2;
        Range<Integer> range = this.lines.get(middle);
        if (range.contains((Comparable)Integer.valueOf(index))) {
            return middle;
        }
        return index < (Integer)range.lowerEndpoint() ? this.doBinarySearch(low, middle, index) : this.doBinarySearch(middle, high, index);
    }
}

