/*
 * Decompiled with CFR 0.152.
 */
package com.github.parboiled1.grappa.matchers.join;

import com.github.parboiled1.grappa.matchers.join.BoundedBothJoinMatcher;
import com.github.parboiled1.grappa.matchers.join.BoundedDownJoinMatcher;
import com.github.parboiled1.grappa.matchers.join.BoundedUpJoinMatcher;
import com.github.parboiled1.grappa.matchers.join.ExactMatchesJoinMatcher;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.parboiled.Rule;
import org.parboiled.annotations.Cached;
import org.parboiled.matchers.EmptyMatcher;
import org.parboiled.matchers.OptionalMatcher;

@ParametersAreNonnullByDefault
@Beta
public final class JoinMatcherBuilder {
    private static final Range<Integer> AT_LEAST_ZERO = Range.atLeast((Comparable)Integer.valueOf(0));
    private final Rule joined;
    private final Rule joining;

    JoinMatcherBuilder(Rule joined, Rule joining) {
        this.joined = joined;
        this.joining = joining;
    }

    public Rule min(int nrCycles) {
        Preconditions.checkArgument((nrCycles >= 0 ? 1 : 0) != 0, (Object)("illegal repetition number specified (" + nrCycles + "), must be 0 or greater"));
        return this.range((Range<Integer>)Range.atLeast((Comparable)Integer.valueOf(nrCycles)));
    }

    public Rule max(int nrCycles) {
        Preconditions.checkArgument((nrCycles >= 0 ? 1 : 0) != 0, (Object)("illegal repetition number specified (" + nrCycles + "), must be 0 or greater"));
        return this.range((Range<Integer>)Range.atMost((Comparable)Integer.valueOf(nrCycles)));
    }

    public Rule times(int nrCycles) {
        Preconditions.checkArgument((nrCycles >= 0 ? 1 : 0) != 0, (Object)("illegal repetition number specified (" + nrCycles + "), must be 0 or greater"));
        return this.range((Range<Integer>)Range.singleton((Comparable)Integer.valueOf(nrCycles)));
    }

    public Rule times(int minCycles, int maxCycles) {
        Preconditions.checkArgument((minCycles >= 0 ? 1 : 0) != 0, (Object)("illegal repetition number specified (" + minCycles + "), must be 0 or greater"));
        Preconditions.checkArgument((maxCycles >= minCycles ? 1 : 0) != 0, (Object)("illegal range specified (" + minCycles + ", " + maxCycles + "): maximum must be greater than minimum"));
        return this.range((Range<Integer>)Range.closed((Comparable)Integer.valueOf(minCycles), (Comparable)Integer.valueOf(maxCycles)));
    }

    @Cached
    public Rule range(@Nonnull Range<Integer> range) {
        Preconditions.checkNotNull(range, (Object)"range must not be null");
        Range realRange = AT_LEAST_ZERO.intersection(range);
        Preconditions.checkArgument((!realRange.isEmpty() ? 1 : 0) != 0, (Object)("illegal range " + range + ": should not be empty after intersection with " + AT_LEAST_ZERO));
        Range<Integer> closedRange = JoinMatcherBuilder.toClosedRange((Range<Integer>)realRange);
        int lowerBound = (Integer)closedRange.lowerEndpoint();
        if (!closedRange.hasUpperBound()) {
            return new BoundedDownJoinMatcher(this.joined, this.joining, lowerBound);
        }
        int upperBound = (Integer)closedRange.upperEndpoint();
        if (upperBound == 0) {
            return new EmptyMatcher();
        }
        if (upperBound == 1) {
            return lowerBound == 0 ? new OptionalMatcher(this.joined) : this.joined;
        }
        if (lowerBound == 0) {
            return new BoundedUpJoinMatcher(this.joined, this.joining, upperBound);
        }
        return lowerBound == upperBound ? new ExactMatchesJoinMatcher(this.joined, this.joining, lowerBound) : new BoundedBothJoinMatcher(this.joined, this.joining, lowerBound, upperBound);
    }

    private static Range<Integer> toClosedRange(Range<Integer> range) {
        Range canonical = range.canonical(DiscreteDomain.integers());
        int lowerBound = (Integer)canonical.lowerEndpoint();
        return canonical.hasUpperBound() ? Range.closed((Comparable)Integer.valueOf(lowerBound), (Comparable)Integer.valueOf((Integer)canonical.upperEndpoint() - 1)) : Range.atLeast((Comparable)Integer.valueOf(lowerBound));
    }
}

