/*
 * Decompiled with CFR 0.152.
 */
package com.github.parboiled1.grappa.matchers.unicode;

import com.github.parboiled1.grappa.matchers.unicode.UnicodeRangeMatcher;
import org.parboiled.MatcherContext;

public class SingleLeadSurrogateRangeMatcher
extends UnicodeRangeMatcher {
    private final char lead;
    private final char lowTrail;
    private final char highTrail;

    SingleLeadSurrogateRangeMatcher(String label, char lead, char lowTrail, char highTrail) {
        super(label);
        this.lead = lead;
        this.lowTrail = lowTrail;
        this.highTrail = highTrail;
    }

    @Override
    public boolean isSingleCharMatcher() {
        return false;
    }

    @Override
    public boolean canMatchEmpty() {
        return false;
    }

    @Override
    public boolean isStarterChar(char c) {
        return c == this.lead;
    }

    @Override
    public char getStarterChar() {
        return this.lead;
    }

    @Override
    public <V> boolean match(MatcherContext<V> context) {
        char tested = context.getCurrentChar();
        if (tested != this.lead) {
            return false;
        }
        context.advanceIndex(1);
        tested = context.getCurrentChar();
        if (tested >= this.lowTrail && tested <= this.highTrail) {
            context.advanceIndex(1);
            context.createNode();
            return true;
        }
        context.advanceIndex(-1);
        return false;
    }
}

