/*
 * Decompiled with CFR 0.152.
 */
package com.github.parboiled1.grappa.misc;

import com.google.common.io.CharSink;
import java.io.IOException;
import java.io.Writer;
import java.nio.CharBuffer;
import javax.annotation.Nonnull;

public final class SystemOutCharSink
extends CharSink {
    public static final CharSink INSTANCE = new SystemOutCharSink();

    private SystemOutCharSink() {
    }

    public Writer openStream() throws IOException {
        return SystemOutWriter.INSTANCE;
    }

    private static final class SystemOutWriter
    extends Writer {
        private static final Writer INSTANCE = new SystemOutWriter();

        private SystemOutWriter() {
        }

        @Override
        public void write(@Nonnull char[] cbuf, int off, int len) throws IOException {
            System.out.append(CharBuffer.wrap(cbuf, off, len));
        }

        @Override
        public void flush() throws IOException {
            System.out.flush();
        }

        @Override
        public void close() throws IOException {
        }
    }
}

