/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.errors;

import com.google.common.base.Preconditions;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.errors.ParseError;

public class BasicParseError
implements ParseError {
    private final InputBuffer inputBuffer;
    private final int startIndex;
    private final String errorMessage;
    private int endIndex;
    private int indexDelta;

    public BasicParseError(InputBuffer inputBuffer, int errorIndex, String errorMessage) {
        this.inputBuffer = (InputBuffer)Preconditions.checkNotNull((Object)inputBuffer);
        this.startIndex = errorIndex;
        this.endIndex = errorIndex + 1;
        this.errorMessage = errorMessage;
    }

    @Override
    public InputBuffer getInputBuffer() {
        return this.inputBuffer;
    }

    @Override
    public int getStartIndex() {
        return this.startIndex + this.indexDelta;
    }

    @Override
    public int getEndIndex() {
        return this.endIndex + this.indexDelta;
    }

    public void setEndIndex(int endIndex) {
        this.endIndex = endIndex - this.indexDelta;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getIndexDelta() {
        return this.indexDelta;
    }

    public void shiftIndexDeltaBy(int delta) {
        this.indexDelta += delta;
    }
}

