/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.matchers;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.List;
import org.parboiled.Action;
import org.parboiled.ContextAware;
import org.parboiled.MatcherContext;
import org.parboiled.Rule;
import org.parboiled.SkippableAction;
import org.parboiled.errors.ActionError;
import org.parboiled.errors.ActionException;
import org.parboiled.matchers.AbstractMatcher;
import org.parboiled.matchervisitors.MatcherVisitor;

public class ActionMatcher
extends AbstractMatcher {
    public final Action<?> action;
    public final List<ContextAware<?>> contextAwares = Lists.newArrayList();
    public final boolean skipInPredicates;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionMatcher(Action<?> action) {
        super(((Action)Preconditions.checkNotNull(action)).toString());
        this.action = action;
        this.skipInPredicates = action instanceof SkippableAction && ((SkippableAction)action).skipInPredicates();
        Class<?> actionClass = action.getClass();
        if (actionClass.isSynthetic()) {
            return;
        }
        if (action instanceof ContextAware) {
            this.contextAwares.add((ContextAware)((Object)action));
        }
        for (Field field : actionClass.getDeclaredFields()) {
            if (!field.isSynthetic() || !ContextAware.class.isAssignableFrom(field.getType())) continue;
            field.setAccessible(true);
            try {
                ContextAware contextAware = (ContextAware)field.get(action);
                if (contextAware == null) continue;
                this.contextAwares.add(contextAware);
            }
            catch (IllegalAccessException ignored) {
            }
            finally {
                field.setAccessible(false);
            }
        }
    }

    @Override
    public <V> MatcherContext<V> getSubContext(MatcherContext<V> context) {
        MatcherContext<V> subContext = context.getBasicSubContext();
        subContext.setMatcher(this);
        return context.getCurrentIndex() > context.getStartIndex() ? subContext : context.getSubContext(this);
    }

    @Override
    public <V> boolean match(MatcherContext<V> context) {
        if (this.skipInPredicates && context.inPredicate()) {
            return true;
        }
        MatcherContext<V> parentContext = context.getParent();
        for (ContextAware<?> contextAware : this.contextAwares) {
            contextAware.setContext(parentContext);
        }
        try {
            Object valueStackSnapshot = context.getValueStack().takeSnapshot();
            if (!this.action.run(parentContext)) {
                context.getValueStack().restoreSnapshot(valueStackSnapshot);
                return false;
            }
            context.setCurrentIndex(parentContext.getCurrentIndex());
            return true;
        }
        catch (ActionException e) {
            ActionError error = new ActionError(context.getInputBuffer(), context.getCurrentIndex(), e.getMessage(), context.getPath(), e);
            context.getParseErrors().add(error);
            return false;
        }
    }

    @Override
    public Rule suppressNode() {
        return this;
    }

    @Override
    public <R> R accept(MatcherVisitor<R> visitor) {
        Preconditions.checkNotNull(visitor, (Object)"visitor");
        return visitor.visit(this);
    }
}

