/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.matchers;

import com.google.common.base.Preconditions;
import java.util.List;
import org.parboiled.MatcherContext;
import org.parboiled.Rule;
import org.parboiled.matchers.Matcher;
import org.parboiled.matchervisitors.MatcherVisitor;
import org.parboiled.support.Var;

public class VarFramingMatcher
implements Matcher {
    private final Matcher inner;
    private final Var<?>[] variables;

    public VarFramingMatcher(Rule inner, Var<?>[] variables) {
        this.inner = (Matcher)Preconditions.checkNotNull((Object)((Matcher)inner), (Object)"inner");
        this.variables = (Var[])Preconditions.checkNotNull(variables, (Object)"variables");
    }

    @Override
    public <V> boolean match(MatcherContext<V> context) {
        for (Var<?> var : this.variables) {
            var.enterFrame();
        }
        boolean matched = this.inner.match(context);
        for (Var<?> var : this.variables) {
            var.exitFrame();
        }
        return matched;
    }

    @Override
    public List<Matcher> getChildren() {
        return this.inner.getChildren();
    }

    @Override
    public Rule label(String label) {
        return new VarFramingMatcher(this.inner.label(label), this.variables);
    }

    @Override
    public Rule suppressNode() {
        return new VarFramingMatcher(this.inner.suppressNode(), this.variables);
    }

    @Override
    public Rule suppressSubnodes() {
        return new VarFramingMatcher(this.inner.suppressSubnodes(), this.variables);
    }

    @Override
    public Rule skipNode() {
        return new VarFramingMatcher(this.inner.skipNode(), this.variables);
    }

    @Override
    public Rule memoMismatches() {
        return new VarFramingMatcher(this.inner.memoMismatches(), this.variables);
    }

    @Override
    public String getLabel() {
        return this.inner.getLabel();
    }

    @Override
    public boolean hasCustomLabel() {
        return this.inner.hasCustomLabel();
    }

    @Override
    public boolean isNodeSuppressed() {
        return this.inner.isNodeSuppressed();
    }

    @Override
    public boolean areSubnodesSuppressed() {
        return this.inner.areSubnodesSuppressed();
    }

    @Override
    public boolean isNodeSkipped() {
        return this.inner.isNodeSkipped();
    }

    @Override
    public boolean areMismatchesMemoed() {
        return this.inner.areMismatchesMemoed();
    }

    @Override
    public void setTag(Object tagObject) {
        this.inner.setTag(tagObject);
    }

    @Override
    public Object getTag() {
        return this.inner.getTag();
    }

    @Override
    public <V> MatcherContext<V> getSubContext(MatcherContext<V> context) {
        MatcherContext<V> subContext = this.inner.getSubContext(context);
        subContext.setMatcher(this);
        return subContext;
    }

    @Override
    public <R> R accept(MatcherVisitor<R> visitor) {
        Preconditions.checkNotNull(visitor, (Object)"visitor");
        return this.inner.accept(visitor);
    }

    public String toString() {
        return this.inner.toString();
    }

    public static Matcher unwrap(Matcher matcher) {
        if (!(matcher instanceof VarFramingMatcher)) {
            return matcher;
        }
        return VarFramingMatcher.unwrap(((VarFramingMatcher)matcher).inner);
    }
}

