/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.matchers;

import com.google.common.base.Preconditions;
import org.parboiled.MatcherContext;
import org.parboiled.Rule;
import org.parboiled.errors.GrammarException;
import org.parboiled.matchers.CustomDefaultLabelMatcher;
import org.parboiled.matchers.Matcher;
import org.parboiled.matchervisitors.MatcherVisitor;

public class ZeroOrMoreMatcher
extends CustomDefaultLabelMatcher<ZeroOrMoreMatcher> {
    public final Matcher subMatcher = (Matcher)this.getChildren().get(0);

    public ZeroOrMoreMatcher(Rule subRule) {
        super((Rule)Preconditions.checkNotNull((Object)subRule, (Object)"subRule"), "zeroOrMore");
    }

    @Override
    public <V> boolean match(MatcherContext<V> context) {
        Preconditions.checkNotNull(context, (Object)"context");
        int lastIndex = context.getCurrentIndex();
        while (this.subMatcher.getSubContext(context).runMatcher()) {
            int currentLocation = context.getCurrentIndex();
            if (currentLocation == lastIndex) {
                throw new GrammarException("The inner rule of zeroOrMore rule '%s' must not allow empty matches", context.getPath());
            }
            lastIndex = currentLocation;
        }
        context.createNode();
        return true;
    }

    @Override
    public <R> R accept(MatcherVisitor<R> visitor) {
        Preconditions.checkNotNull(visitor, (Object)"visitor");
        return visitor.visit(this);
    }
}

