/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.parserunners;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Queues;
import com.google.common.primitives.Ints;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nullable;
import org.parboiled.MatchHandler;
import org.parboiled.MatcherContext;
import org.parboiled.Rule;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.buffers.MutableInputBuffer;
import org.parboiled.errors.InvalidInputError;
import org.parboiled.errors.ParseError;
import org.parboiled.matchers.AbstractMatcher;
import org.parboiled.matchers.ActionMatcher;
import org.parboiled.matchers.EmptyMatcher;
import org.parboiled.matchers.FirstOfMatcher;
import org.parboiled.matchers.Matcher;
import org.parboiled.matchers.OneOrMoreMatcher;
import org.parboiled.matchers.SequenceMatcher;
import org.parboiled.matchers.TestMatcher;
import org.parboiled.matchervisitors.DefaultMatcherVisitor;
import org.parboiled.matchervisitors.FollowMatchersVisitor;
import org.parboiled.matchervisitors.GetStarterCharVisitor;
import org.parboiled.matchervisitors.IsSingleCharMatcherVisitor;
import org.parboiled.matchervisitors.IsStarterCharVisitor;
import org.parboiled.parserunners.AbstractParseRunner;
import org.parboiled.parserunners.BasicParseRunner;
import org.parboiled.parserunners.ErrorLocatingParseRunner;
import org.parboiled.parserunners.ErrorReportingParseRunner;
import org.parboiled.parserunners.ParseRunner;
import org.parboiled.support.MatcherPath;
import org.parboiled.support.ParsingResult;

public class RecoveringParseRunner<V>
extends AbstractParseRunner<V> {
    private final long timeout;
    private long startTimeStamp;
    private int errorIndex;
    private InvalidInputError currentError;
    private MutableInputBuffer buffer;
    private ParsingResult<V> lastParsingResult;
    private Matcher rootMatcherNoTreeBuild;

    @Deprecated
    public static <V> ParsingResult<V> run(Rule rule, String input) {
        Preconditions.checkNotNull((Object)rule, (Object)"rule");
        Preconditions.checkNotNull((Object)input, (Object)"input");
        return new RecoveringParseRunner<V>(rule).run(input);
    }

    public RecoveringParseRunner(Rule rule) {
        this(rule, Long.MAX_VALUE);
    }

    public RecoveringParseRunner(Rule rule, long timeout) {
        super(rule);
        this.timeout = timeout;
    }

    @Override
    public ParsingResult<V> run(InputBuffer inputBuffer) {
        Preconditions.checkNotNull((Object)inputBuffer, (Object)"inputBuffer");
        this.startTimeStamp = System.currentTimeMillis();
        this.resetValueStack();
        ParseRunner basicRunner = new BasicParseRunner(this.rootMatcher).withParseErrors(this.parseErrors).withValueStack(this.valueStack);
        this.lastParsingResult = basicRunner.run(inputBuffer);
        if (!this.lastParsingResult.isSuccess()) {
            this.rootMatcherNoTreeBuild = (Matcher)this.rootMatcher.suppressNode();
            this.performLocatingRun(inputBuffer);
            Preconditions.checkState((this.errorIndex >= 0 ? 1 : 0) != 0);
            this.buffer = new MutableInputBuffer(inputBuffer);
            this.performReportingRun();
            while (!this.fixError(this.errorIndex)) {
                this.performReportingRun();
            }
            if (!this.rootMatcher.isNodeSuppressed()) {
                this.performFinalRun();
                Preconditions.checkState((boolean)this.lastParsingResult.isSuccess());
            }
        }
        return this.lastParsingResult;
    }

    private boolean performLocatingRun(InputBuffer inputBuffer) {
        this.resetValueStack();
        ParseRunner locatingRunner = new ErrorLocatingParseRunner(this.rootMatcherNoTreeBuild, this.getInnerHandler()).withParseErrors(this.parseErrors).withValueStack(this.valueStack);
        this.lastParsingResult = locatingRunner.run(inputBuffer);
        this.errorIndex = this.lastParsingResult.isSuccess() ? -1 : ((ParseError)this.parseErrors.remove(this.parseErrors.size() - 1)).getStartIndex();
        return this.lastParsingResult.isSuccess();
    }

    private void performReportingRun() {
        this.resetValueStack();
        ParseRunner reportingRunner = new ErrorReportingParseRunner(this.rootMatcherNoTreeBuild, this.errorIndex, this.getInnerHandler()).withParseErrors(this.parseErrors).withValueStack(this.valueStack);
        ParsingResult result = reportingRunner.run(this.buffer);
        Preconditions.checkState((!result.isSuccess() ? 1 : 0) != 0);
        Preconditions.checkState((boolean)result.hasCollectedParseErrors());
        this.currentError = (InvalidInputError)this.parseErrors.get(this.parseErrors.size() - 1);
    }

    private void performFinalRun() {
        this.resetValueStack();
        Handler handler = new Handler();
        MatcherContext rootContext = this.createRootContext(this.buffer, handler, false);
        boolean matched = handler.match(rootContext);
        this.lastParsingResult = this.createParsingResult(matched, rootContext);
    }

    private MatchHandler getInnerHandler() {
        return this.errorIndex >= 0 ? new Handler() : null;
    }

    private boolean fixError(int fixIndex) {
        if (this.trySingleCharDeletion(fixIndex)) {
            return true;
        }
        int singleCharDelFix = this.errorIndex;
        Character bestInsertionCharacter = this.findSingleCharInsert(fixIndex);
        if (bestInsertionCharacter == null) {
            return true;
        }
        int singleCharInsertFix = this.errorIndex;
        Character bestReplacementCharacter = this.findSingleCharReplace(fixIndex);
        if (bestReplacementCharacter == null) {
            return true;
        }
        int singleCharReplaceFix = this.errorIndex;
        int singleCharFix = Ints.max((int[])new int[]{singleCharDelFix, singleCharInsertFix, singleCharReplaceFix});
        if (singleCharFix > fixIndex) {
            if (singleCharFix == singleCharDelFix) {
                this.buffer.insertChar(fixIndex, '\ufdea');
                this.errorIndex = singleCharDelFix + 1;
                this.currentError.shiftIndexDeltaBy(1);
            } else if (singleCharFix == singleCharInsertFix) {
                this.buffer.insertChar(fixIndex, bestInsertionCharacter.charValue());
                this.buffer.insertChar(fixIndex, '\ufdeb');
                this.errorIndex = singleCharInsertFix + 2;
                this.currentError.shiftIndexDeltaBy(2);
            } else {
                this.buffer.insertChar(fixIndex + 1, bestReplacementCharacter.charValue());
                this.buffer.insertChar(fixIndex + 1, '\ufdeb');
                this.buffer.insertChar(fixIndex, '\ufdea');
                this.errorIndex = singleCharReplaceFix + 5;
                this.currentError.shiftIndexDeltaBy(1);
            }
        } else {
            if (this.buffer.charAt(fixIndex) == '\uffff') {
                this.buffer.insertChar(fixIndex, '\ufdef');
                this.currentError.shiftIndexDeltaBy(1);
                return true;
            }
            this.buffer.insertChar(fixIndex, '\ufdec');
            this.currentError.shiftIndexDeltaBy(1);
            this.performLocatingRun(this.buffer);
        }
        return this.errorIndex == -1;
    }

    private boolean trySingleCharDeletion(int fixIndex) {
        this.buffer.insertChar(fixIndex, '\ufdea');
        boolean nowErrorFree = this.performLocatingRun(this.buffer);
        if (nowErrorFree) {
            this.currentError.shiftIndexDeltaBy(1);
        } else {
            this.buffer.undoCharInsertion(fixIndex);
            this.errorIndex = Math.max(this.errorIndex - 1, 0);
        }
        return nowErrorFree;
    }

    @Nullable
    private Character findSingleCharInsert(int fixIndex) {
        GetStarterCharVisitor visitor = new GetStarterCharVisitor();
        int bestNextErrorIndex = -1;
        Character bestChar = Character.valueOf('\u0000');
        for (MatcherPath path : this.currentError.getFailedMatchers()) {
            Character starterChar = path.getElement().getMatcher().accept(visitor);
            Preconditions.checkState((starterChar != null ? 1 : 0) != 0);
            if (starterChar.charValue() == '\uffff') continue;
            this.buffer.insertChar(fixIndex, starterChar.charValue());
            this.buffer.insertChar(fixIndex, '\ufdeb');
            if (this.performLocatingRun(this.buffer)) {
                this.currentError.shiftIndexDeltaBy(2);
                return null;
            }
            this.buffer.undoCharInsertion(fixIndex);
            this.buffer.undoCharInsertion(fixIndex);
            this.errorIndex = Math.max(this.errorIndex - 2, 0);
            if (bestNextErrorIndex >= this.errorIndex) continue;
            bestNextErrorIndex = this.errorIndex;
            bestChar = starterChar;
        }
        this.errorIndex = bestNextErrorIndex;
        return bestChar;
    }

    @Nullable
    private Character findSingleCharReplace(int fixIndex) {
        this.buffer.insertChar(fixIndex, '\ufdea');
        Character bestChar = this.findSingleCharInsert(fixIndex + 2);
        if (bestChar == null) {
            this.currentError.shiftIndexDeltaBy(-1);
        } else {
            this.buffer.undoCharInsertion(fixIndex);
            this.errorIndex = Math.max(this.errorIndex - 3, 0);
        }
        return bestChar;
    }

    private static class CollectResyncActionsVisitor
    extends DefaultMatcherVisitor<List<ActionMatcher>> {
        private Deque<SequenceMatcher> path = Queues.newArrayDeque();

        private CollectResyncActionsVisitor() {
        }

        @Override
        public List<ActionMatcher> visit(ActionMatcher matcher) {
            return ImmutableList.of((Object)matcher);
        }

        @Override
        public List<ActionMatcher> visit(FirstOfMatcher matcher) {
            for (Matcher child : matcher.getChildren()) {
                List<ActionMatcher> actions = child.accept(this);
                if (actions == null) continue;
                return actions;
            }
            return null;
        }

        @Override
        public List<ActionMatcher> visit(OneOrMoreMatcher matcher) {
            return matcher.subMatcher.accept(this);
        }

        @Override
        public List<ActionMatcher> visit(SequenceMatcher matcher) {
            if (this.path.contains(matcher)) {
                return ImmutableList.of();
            }
            ArrayDeque previousPath = Queues.newArrayDeque(this.path);
            this.path.push(matcher);
            ArrayList<ActionMatcher> actions = new ArrayList<ActionMatcher>();
            for (Matcher sub : matcher.getChildren()) {
                List<ActionMatcher> subActions = sub.accept(this);
                if (subActions == null) {
                    return ImmutableList.of();
                }
                actions.addAll(subActions);
            }
            this.path = previousPath;
            return actions;
        }

        @Override
        public List<ActionMatcher> defaultValue(AbstractMatcher matcher) {
            return ImmutableList.of();
        }
    }

    private class Handler
    implements MatchHandler {
        private final IsSingleCharMatcherVisitor visitor = new IsSingleCharMatcherVisitor();
        private int fringeIndex;
        private MatcherPath lastMatchPath;

        private Handler() {
        }

        @Override
        public <V> boolean match(MatcherContext<V> context) {
            Matcher matcher = context.getMatcher();
            if (matcher.accept(this.visitor).booleanValue()) {
                if (!this.prepareErrorLocation(context) || !matcher.match(context)) {
                    return false;
                }
                if (this.fringeIndex < context.getCurrentIndex()) {
                    this.fringeIndex = context.getCurrentIndex();
                    this.lastMatchPath = context.getPath();
                }
                return true;
            }
            if (matcher.match(context)) {
                return true;
            }
            if (!(matcher instanceof SequenceMatcher)) {
                return false;
            }
            switch (context.getCurrentChar()) {
                case '\ufdec': 
                case '\ufded': 
                case '\ufdef': {
                    return this.qualifiesForResync(context) && this.resynchronize(context);
                }
            }
            if (System.currentTimeMillis() - RecoveringParseRunner.this.startTimeStamp > RecoveringParseRunner.this.timeout) {
                throw new TimeoutException(RecoveringParseRunner.this.rootMatcher, RecoveringParseRunner.this.buffer, RecoveringParseRunner.this.lastParsingResult);
            }
            return false;
        }

        private boolean qualifiesForResync(MatcherContext<?> context) {
            int currentIndex = context.getCurrentIndex();
            int startIndex = context.getStartIndex();
            MatcherPath path = context.getPath();
            if (currentIndex != startIndex && path.isPrefixOf(this.lastMatchPath)) {
                return true;
            }
            for (MatcherContext<?> parent = context.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent.getMatcher() instanceof SequenceMatcher)) continue;
                return false;
            }
            return true;
        }

        private boolean prepareErrorLocation(MatcherContext<?> context) {
            switch (context.getCurrentChar()) {
                case '\ufdea': {
                    return this.willMatchDelError(context);
                }
                case '\ufdeb': {
                    return this.willMatchInsError(context);
                }
                case '\ufdec': 
                case '\ufded': 
                case '\ufdef': {
                    return false;
                }
            }
            return true;
        }

        private boolean willMatchDelError(MatcherContext<?> context) {
            int preSkipIndex = context.getCurrentIndex();
            context.advanceIndex(2);
            if (!this.runTestMatch(context)) {
                context.setCurrentIndex(preSkipIndex);
                return false;
            }
            context.setStartIndex(context.getCurrentIndex());
            if (context.getParent() != null) {
                context.getParent().markError();
            }
            return true;
        }

        private boolean willMatchInsError(MatcherContext<?> context) {
            int preSkipIndex = context.getCurrentIndex();
            context.advanceIndex(1);
            if (!this.runTestMatch(context)) {
                context.setCurrentIndex(preSkipIndex);
                return false;
            }
            context.setStartIndex(context.getCurrentIndex());
            context.markError();
            return true;
        }

        private boolean runTestMatch(MatcherContext<?> context) {
            TestMatcher testMatcher = new TestMatcher(context.getMatcher());
            MatcherContext<?> testContext = testMatcher.getSubContext(context);
            return this.prepareErrorLocation(testContext) && testContext.runMatcher();
        }

        private boolean resynchronize(MatcherContext<?> context) {
            context.markError();
            context.createNode();
            this.rerunWithActions(context);
            switch (context.getCurrentChar()) {
                case '\ufdec': {
                    context.advanceIndex(1);
                    List<Matcher> matchers = new FollowMatchersVisitor().getFollowMatchers(context);
                    int endIndex = this.gobbleIllegalCharacters(context, matchers);
                    RecoveringParseRunner.this.currentError.setEndIndex(endIndex);
                    RecoveringParseRunner.this.buffer.replaceInsertedChar(RecoveringParseRunner.this.currentError.getStartIndex() - 1, '\ufded');
                    RecoveringParseRunner.this.buffer.insertChar(endIndex, '\ufdee');
                    context.advanceIndex(1);
                    break;
                }
                case '\ufded': {
                    context.advanceIndex(1);
                    while (context.getCurrentChar() != '\ufdee') {
                        context.advanceIndex(1);
                        Preconditions.checkState((context.getCurrentChar() != '\uffff' ? 1 : 0) != 0);
                    }
                    context.advanceIndex(1);
                    break;
                }
                case '\ufdef': {
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return true;
        }

        private void rerunWithActions(MatcherContext<?> context) {
            int savedCurrentIndex = context.getCurrentIndex();
            context.setCurrentIndex(context.getStartIndex());
            boolean preError = true;
            for (Matcher child : context.getMatcher().getChildren()) {
                if (preError && !child.getSubContext(context).runMatcher()) {
                    new EmptyMatcher().getSubContext(context).runMatcher();
                    context.setIntTag(1);
                    preError = false;
                }
                if (preError) continue;
                context.setInErrorRecovery(true);
                List<ActionMatcher> errorActions = child.accept(new CollectResyncActionsVisitor());
                Preconditions.checkState((errorActions != null ? 1 : 0) != 0);
                for (ActionMatcher errorAction : errorActions) {
                    errorAction.getSubContext(context).runMatcher();
                }
                context.setInErrorRecovery(false);
            }
            context.setCurrentIndex(savedCurrentIndex);
        }

        private int gobbleIllegalCharacters(MatcherContext<?> context, List<Matcher> followMatchers) {
            char currentChar;
            while ((currentChar = context.getCurrentChar()) != '\uffff') {
                IsStarterCharVisitor visitor = new IsStarterCharVisitor(currentChar);
                for (Matcher followMatcher : followMatchers) {
                    if (!followMatcher.accept(visitor).booleanValue()) continue;
                    return context.getCurrentIndex();
                }
                context.advanceIndex(1);
            }
            return context.getCurrentIndex();
        }
    }

    public static class TimeoutException
    extends RuntimeException {
        public final Rule rule;
        public final InputBuffer inputBuffer;
        public final ParsingResult<?> lastParsingResult;

        public TimeoutException(Rule rule, InputBuffer inputBuffer, ParsingResult<?> lastParsingResult) {
            this.rule = rule;
            this.inputBuffer = inputBuffer;
            this.lastParsingResult = lastParsingResult;
        }
    }
}

