/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.support;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;

public class Chars {
    public static final char DEL_ERROR = '\ufdea';
    public static final char INS_ERROR = '\ufdeb';
    public static final char RESYNC = '\ufdec';
    public static final char RESYNC_START = '\ufded';
    public static final char RESYNC_END = '\ufdee';
    public static final char RESYNC_EOI = '\ufdef';
    public static final char EOI = '\uffff';
    @Deprecated
    public static final char INDENT = '\ufdd0';
    @Deprecated
    public static final char DEDENT = '\ufdd1';
    private static final Map<Character, String> ESCAPE_MAP = ImmutableMap.builder().put((Object)Character.valueOf('\r'), (Object)"\\r").put((Object)Character.valueOf('\n'), (Object)"\\n").put((Object)Character.valueOf('\t'), (Object)"\\t").put((Object)Character.valueOf('\f'), (Object)"\\f").put((Object)Character.valueOf('\ufdea'), (Object)"DEL_ERROR").put((Object)Character.valueOf('\ufdeb'), (Object)"INS_ERROR").put((Object)Character.valueOf('\ufdec'), (Object)"RESYNC").put((Object)Character.valueOf('\ufded'), (Object)"RESYNC_START").put((Object)Character.valueOf('\ufdee'), (Object)"RESYNC_END").put((Object)Character.valueOf('\ufdef'), (Object)"RESYNC_EOI").put((Object)Character.valueOf('\ufdd0'), (Object)"INDENT").put((Object)Character.valueOf('\ufdd1'), (Object)"DEDENT").put((Object)Character.valueOf('\uffff'), (Object)"EOI").build();

    private Chars() {
    }

    public static Map<Character, String> escapeMap() {
        return ESCAPE_MAP;
    }

    public static String escape(char c) {
        return (String)Optional.fromNullable((Object)ESCAPE_MAP.get(Character.valueOf(c))).or((Object)String.valueOf(c));
    }

    public static String repeat(char c, int n) {
        char[] array = new char[n];
        Arrays.fill(array, c);
        return new String(array);
    }
}

