/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.support;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.parboiled.matchers.Matcher;

public class MatcherPath {
    public final Element element;
    public final MatcherPath parent;

    public MatcherPath(Element element, @Nullable MatcherPath parent) {
        this.element = (Element)Preconditions.checkNotNull((Object)element, (Object)"element");
        this.parent = parent;
    }

    public int length() {
        return this.element.getLevel() + 1;
    }

    public boolean isPrefixOf(MatcherPath that) {
        Preconditions.checkNotNull((Object)that, (Object)"that");
        if (this.element.getLevel() <= that.getElement().getLevel() && this == that) {
            return true;
        }
        if (!that.hasParent()) {
            return false;
        }
        return this.isPrefixOf(that.getParent());
    }

    public final Element getElement() {
        return this.element;
    }

    public final MatcherPath getParent() {
        return this.parent;
    }

    public final boolean hasParent() {
        return this.parent != null;
    }

    @Nullable
    public Element getElementAtLevel(int level) {
        Preconditions.checkArgument((level >= 0 ? 1 : 0) != 0);
        if (level > this.element.getLevel()) {
            return null;
        }
        if (level < this.element.getLevel()) {
            return this.parent.getElementAtLevel(level);
        }
        return this.element;
    }

    @Nullable
    public MatcherPath commonPrefix(MatcherPath that) {
        Preconditions.checkNotNull((Object)that, (Object)"that");
        if (this.element.getLevel() > that.getElement().getLevel()) {
            return this.parent.commonPrefix(that);
        }
        if (this.element.getLevel() < that.getElement().getLevel()) {
            return this.commonPrefix(that.getParent());
        }
        if (this == that) {
            return this;
        }
        return this.hasParent() && that.hasParent() ? this.parent.commonPrefix(that.getParent()) : null;
    }

    public boolean contains(Matcher matcher) {
        if (this.element.getMatcher() == matcher) {
            return true;
        }
        if (this.parent == null) {
            return false;
        }
        return this.parent.contains(matcher);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(MatcherPath skipPrefix) {
        return this.print(new StringBuilder(), skipPrefix).toString();
    }

    private StringBuilder print(StringBuilder sb, MatcherPath skipPrefix) {
        return (this.parent == skipPrefix ? sb : this.parent.print(sb, skipPrefix).append('/')).append(this.element.getMatcher());
    }

    public static class Element {
        public final Matcher matcher;
        public final int startIndex;
        public final int level;

        public Element(Matcher matcher, int startIndex, int level) {
            this.matcher = matcher;
            this.startIndex = startIndex;
            this.level = level;
        }

        public final Matcher getMatcher() {
            return this.matcher;
        }

        public final int getStartIndex() {
            return this.startIndex;
        }

        public int getLevel() {
            return this.level;
        }
    }
}

