/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import com.github.parboiled1.grappa.transform.method.ParserAnnotation;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;
import org.parboiled.support.Checks;
import org.parboiled.transform.AsmUtils;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.Types;

public class ClassNodeInitializer
extends ClassVisitor {
    private static final Set<ParserAnnotation> CLASS_FLAGS_CLEAR = EnumSet.of(ParserAnnotation.EXPLICIT_ACTIONS_ONLY, ParserAnnotation.DONT_LABEL, ParserAnnotation.SKIP_ACTIONS_IN_PREDICATES);
    private ParserClassNode classNode;
    private Class<?> ownerClass;
    private final Set<ParserAnnotation> annotations = EnumSet.noneOf(ParserAnnotation.class);

    public ClassNodeInitializer() {
        super(327680);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(ParserClassNode classNode) throws IOException {
        this.classNode = (ParserClassNode)((Object)Preconditions.checkNotNull((Object)((Object)classNode), (Object)"classNode"));
        this.ownerClass = classNode.getParentClass();
        while (!Object.class.equals(this.ownerClass)) {
            this.annotations.removeAll(CLASS_FLAGS_CLEAR);
            Closer closer = Closer.create();
            try {
                InputStream in = ClassNodeInitializer.getInputStream(this.ownerClass);
                if (in == null) {
                    throw new IOException(this.ownerClass + " not found");
                }
                ClassReader reader = new ClassReader((InputStream)closer.register((Closeable)in));
                reader.accept((ClassVisitor)this, 4);
            }
            finally {
                closer.close();
            }
            this.ownerClass = this.ownerClass.getSuperclass();
        }
        for (RuleMethod method : classNode.getRuleMethods().values()) {
            if (method.isSuperMethod()) {
                RuleMethod overridingMethod = classNode.getRuleMethods().get(method.name.substring(1) + method.desc);
                method.moveFlagsTo(overridingMethod);
                continue;
            }
            if (this.annotations.contains((Object)ParserAnnotation.BUILD_PARSE_TREE)) break;
            method.suppressNode();
        }
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (this.ownerClass == this.classNode.getParentClass()) {
            Checks.ensure((access & 2) == 0, "Parser class '%s' must not be private", name);
            Checks.ensure((access & 0x10) == 0, "Parser class '%s' must not be final.", name);
            this.classNode.visit(50, 1, AsmUtils.getExtendedParserClassName(name), null, this.classNode.getParentType().getInternalName(), null);
        }
    }

    @Nullable
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (ParserAnnotation.recordAnnotation(this.annotations, desc)) {
            return null;
        }
        if (!visible) {
            return null;
        }
        return this.ownerClass == this.classNode.getParentClass() ? this.classNode.visitAnnotation(desc, true) : null;
    }

    public void visitSource(String source, String debug) {
        this.classNode.visitSource(null, null);
    }

    @Nullable
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ("<init>".equals(name)) {
            if (this.ownerClass != this.classNode.getParentClass()) {
                return null;
            }
            if ((access & 2) > 0) {
                return null;
            }
            MethodNode constructor = new MethodNode(access, name, desc, signature, exceptions);
            this.classNode.getConstructors().add(constructor);
            return constructor;
        }
        if (!Type.getReturnType((String)desc).equals((Object)Types.RULE)) {
            return null;
        }
        if ((access & 0x500) > 0) {
            return null;
        }
        Checks.ensure((access & 2) == 0, "Rule method '%s'must not be private.\nMark the method protected or package-private if you want to prevent public access!", name);
        Checks.ensure((access & 0x10) == 0, "Rule method '%s' must not be final.", name);
        String methodKey = name + desc;
        while (this.classNode.getRuleMethods().containsKey(methodKey)) {
            name = '$' + name;
            methodKey = name + desc;
        }
        RuleMethod method = new RuleMethod(this.ownerClass, access, name, desc, signature, exceptions, this.annotations);
        this.classNode.getRuleMethods().put(methodKey, method);
        return method;
    }

    public void visitEnd() {
        this.classNode.visitEnd();
    }

    private static InputStream getInputStream(Class<?> c) {
        Preconditions.checkNotNull(c);
        String name = c.getName().replace('.', '/') + ".class";
        ClassLoader me = ClassNodeInitializer.class.getClassLoader();
        ClassLoader context = Thread.currentThread().getContextClassLoader();
        return (InputStream)Optional.fromNullable((Object)me.getResourceAsStream(name)).or((Object)context.getResourceAsStream(name));
    }
}

