/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import com.github.parboiled1.grappa.transform.method.ParserAnnotation;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.parboiled.BaseParser;
import org.parboiled.support.Var;
import org.parboiled.transform.AsmUtils;
import org.parboiled.transform.InstructionGraphNode;
import org.parboiled.transform.InstructionGroup;

public class RuleMethod
extends MethodNode {
    private static final Set<ParserAnnotation> COPY_FROM_CLASS = EnumSet.of(ParserAnnotation.DONT_LABEL, ParserAnnotation.EXPLICIT_ACTIONS_ONLY, ParserAnnotation.SKIP_ACTIONS_IN_PREDICATES);
    private final List<InstructionGroup> groups = new ArrayList<InstructionGroup>();
    private final List<LabelNode> usedLabels = new ArrayList<LabelNode>();
    private final Set<ParserAnnotation> annotations = EnumSet.noneOf(ParserAnnotation.class);
    private final Class<?> ownerClass;
    private final int parameterCount;
    private boolean containsImplicitActions;
    private boolean containsExplicitActions;
    private boolean containsVars;
    private boolean containsPotentialSuperCalls;
    private int numberOfReturns;
    private InstructionGraphNode returnInstructionNode;
    private List<InstructionGraphNode> graphNodes;
    private final List<LocalVariableNode> localVarVariables = Lists.newArrayList();
    private boolean bodyRewritten;
    private boolean skipGeneration;

    public RuleMethod(Class<?> ownerClass, int access, String name, String desc, String signature, String[] exceptions, Set<ParserAnnotation> classAnnotations) {
        super(327680, access, name, desc, signature, exceptions);
        this.ownerClass = ownerClass;
        this.parameterCount = Type.getArgumentTypes((String)desc).length;
        if (this.parameterCount == 0) {
            this.annotations.add(ParserAnnotation.CACHED);
        }
        EnumSet<ParserAnnotation> set = EnumSet.copyOf(classAnnotations);
        set.retainAll(COPY_FROM_CLASS);
        this.annotations.addAll(set);
        this.skipGeneration = this.isSuperMethod();
    }

    public List<InstructionGroup> getGroups() {
        return this.groups;
    }

    public List<LabelNode> getUsedLabels() {
        return this.usedLabels;
    }

    public Class<?> getOwnerClass() {
        return this.ownerClass;
    }

    public boolean hasDontExtend() {
        return this.annotations.contains((Object)ParserAnnotation.DONT_EXTEND);
    }

    public int getParameterCount() {
        return this.parameterCount;
    }

    public boolean containsImplicitActions() {
        return this.containsImplicitActions;
    }

    public void setContainsImplicitActions(boolean containsImplicitActions) {
        this.containsImplicitActions = containsImplicitActions;
    }

    public boolean containsExplicitActions() {
        return this.containsExplicitActions;
    }

    public void setContainsExplicitActions(boolean containsExplicitActions) {
        this.containsExplicitActions = containsExplicitActions;
    }

    public boolean containsVars() {
        return this.containsVars;
    }

    public boolean containsPotentialSuperCalls() {
        return this.containsPotentialSuperCalls;
    }

    public boolean hasCachedAnnotation() {
        return this.annotations.contains((Object)ParserAnnotation.CACHED);
    }

    public boolean hasDontLabelAnnotation() {
        return this.annotations.contains((Object)ParserAnnotation.DONT_LABEL);
    }

    public boolean hasSuppressNodeAnnotation() {
        return this.annotations.contains((Object)ParserAnnotation.SUPPRESS_NODE);
    }

    public boolean hasSuppressSubnodesAnnotation() {
        return this.annotations.contains((Object)ParserAnnotation.SUPPRESS_SUBNODES);
    }

    public boolean hasSkipActionsInPredicatesAnnotation() {
        return this.annotations.contains((Object)ParserAnnotation.SKIP_ACTIONS_IN_PREDICATES);
    }

    public boolean hasSkipNodeAnnotation() {
        return this.annotations.contains((Object)ParserAnnotation.SKIP_NODE);
    }

    public boolean hasMemoMismatchesAnnotation() {
        return this.annotations.contains((Object)ParserAnnotation.MEMO_MISMATCHES);
    }

    public int getNumberOfReturns() {
        return this.numberOfReturns;
    }

    public InstructionGraphNode getReturnInstructionNode() {
        return this.returnInstructionNode;
    }

    public void setReturnInstructionNode(InstructionGraphNode returnInstructionNode) {
        this.returnInstructionNode = returnInstructionNode;
    }

    public List<InstructionGraphNode> getGraphNodes() {
        return this.graphNodes;
    }

    public List<LocalVariableNode> getLocalVarVariables() {
        return this.localVarVariables;
    }

    public boolean isBodyRewritten() {
        return this.bodyRewritten;
    }

    public void setBodyRewritten() {
        this.bodyRewritten = true;
    }

    public boolean isSuperMethod() {
        Preconditions.checkState((!this.name.isEmpty() ? 1 : 0) != 0);
        return this.name.charAt(0) == '$';
    }

    public InstructionGraphNode setGraphNode(AbstractInsnNode insn, BasicValue resultValue, List<BasicValue> predecessors) {
        int index;
        InstructionGraphNode node;
        if (this.graphNodes == null) {
            this.graphNodes = Lists.newArrayList((Object[])new InstructionGraphNode[this.instructions.size()]);
        }
        if ((node = this.graphNodes.get(index = this.instructions.indexOf(insn))) == null) {
            node = new InstructionGraphNode(insn, resultValue);
            this.graphNodes.set(index, node);
        }
        node.addPredecessors(predecessors);
        return node;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        boolean recorded = ParserAnnotation.recordAnnotation(this.annotations, desc);
        if (this.annotations.contains((Object)ParserAnnotation.DONT_SKIP_ACTIONS_IN_PREDICATES)) {
            this.annotations.remove((Object)ParserAnnotation.SKIP_ACTIONS_IN_PREDICATES);
        }
        if (recorded) {
            return null;
        }
        return visible ? super.visitAnnotation(desc, true) : null;
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        switch (opcode) {
            case 184: {
                if (!this.annotations.contains((Object)ParserAnnotation.EXPLICIT_ACTIONS_ONLY) && AsmUtils.isBooleanValueOfZ(owner, name, desc)) {
                    this.containsImplicitActions = true;
                    break;
                }
                if (!AsmUtils.isActionRoot(owner, name)) break;
                this.containsExplicitActions = true;
                break;
            }
            case 183: {
                if ("<init>".equals(name)) {
                    if (!AsmUtils.isVarRoot(owner, name, desc)) break;
                    this.containsVars = true;
                    break;
                }
                if (!AsmUtils.isAssignableTo(owner, BaseParser.class)) break;
                this.containsPotentialSuperCalls = true;
            }
        }
        super.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    public void visitInsn(int opcode) {
        if (opcode == 176) {
            ++this.numberOfReturns;
        }
        super.visitInsn(opcode);
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.usedLabels.add(this.getLabelNode(label));
        super.visitJumpInsn(opcode, label);
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        this.usedLabels.add(this.getLabelNode(dflt));
        for (Label label : labels) {
            this.usedLabels.add(this.getLabelNode(label));
        }
        super.visitTableSwitchInsn(min, max, dflt, labels);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.usedLabels.add(this.getLabelNode(dflt));
        for (Label label : labels) {
            this.usedLabels.add(this.getLabelNode(label));
        }
        super.visitLookupSwitchInsn(dflt, keys, labels);
    }

    public void visitLineNumber(int line, Label start) {
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        Type type = Type.getType((String)desc);
        if (index > this.parameterCount && Var.class.isAssignableFrom(AsmUtils.getClassForType(type))) {
            this.localVarVariables.add(new LocalVariableNode(name, desc, null, null, null, index));
        }
    }

    public String toString() {
        return this.name;
    }

    public void moveFlagsTo(RuleMethod method) {
        Preconditions.checkNotNull((Object)((Object)method));
        ParserAnnotation.moveTo(this.annotations, method.annotations);
    }

    public boolean isGenerationSkipped() {
        return this.skipGeneration;
    }

    public void dontSkipGeneration() {
        this.skipGeneration = false;
    }

    public void suppressNode() {
        this.annotations.add(ParserAnnotation.SUPPRESS_NODE);
    }
}

