/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform.process;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import me.qmx.jitescript.util.CodegenUtils;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.parboiled.Action;
import org.parboiled.BaseParser;
import org.parboiled.transform.AsmUtils;
import org.parboiled.transform.InstructionGraphNode;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.Types;
import org.parboiled.transform.process.RuleMethodProcessor;

public class ImplicitActionsConverter
implements RuleMethodProcessor {
    private final Set<InstructionGraphNode> covered = new HashSet<InstructionGraphNode>();
    private RuleMethod method;

    @Override
    public boolean appliesTo(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) {
        Preconditions.checkNotNull((Object)((Object)classNode), (Object)"classNode");
        Preconditions.checkNotNull((Object)((Object)method), (Object)"method");
        return method.containsImplicitActions();
    }

    @Override
    public void process(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) throws Exception {
        this.method = (RuleMethod)((Object)Preconditions.checkNotNull((Object)((Object)method), (Object)"method"));
        this.covered.clear();
        this.walkNode(method.getReturnInstructionNode());
        method.setContainsImplicitActions(false);
    }

    private void walkNode(InstructionGraphNode node) {
        if (this.covered.contains((Object)node)) {
            return;
        }
        this.covered.add(node);
        if (this.isImplicitAction(node)) {
            this.replaceWithActionWrapper(node);
            this.method.setContainsExplicitActions(true);
            return;
        }
        if (node.isActionRoot()) {
            return;
        }
        for (InstructionGraphNode predecessor : node.getPredecessors()) {
            this.walkNode(predecessor);
        }
    }

    private void replaceWithActionWrapper(InstructionGraphNode node) {
        MethodInsnNode insn = ImplicitActionsConverter.createActionWrappingInsn();
        this.method.instructions.set(node.getInstruction(), (AbstractInsnNode)insn);
        node.setIsActionRoot();
        node.setInstruction((AbstractInsnNode)insn);
    }

    private boolean isImplicitAction(InstructionGraphNode node) {
        if (!AsmUtils.isBooleanValueOfZ(node.getInstruction())) {
            return false;
        }
        List<InstructionGraphNode> dependents = this.getDependents(node);
        if (dependents.size() != 1) {
            return false;
        }
        InstructionGraphNode dependent = dependents.get(0);
        return ImplicitActionsConverter.isObjectArgumentToRuleCreatingMethodCall(node, dependent) || this.isStoredIntoObjectArray(dependent);
    }

    private static boolean isObjectArgumentToRuleCreatingMethodCall(InstructionGraphNode node, InstructionGraphNode dependent) {
        AbstractInsnNode insn = dependent.getInstruction();
        if (insn.getType() != 5) {
            return false;
        }
        MethodInsnNode methodNode = (MethodInsnNode)insn;
        if (!Types.RULE.equals((Object)Type.getReturnType((String)methodNode.desc))) {
            return false;
        }
        Type[] argTypes = Type.getArgumentTypes((String)methodNode.desc);
        int argIndex = ImplicitActionsConverter.getArgumentIndex(dependent, node);
        Preconditions.checkState((argIndex < argTypes.length ? 1 : 0) != 0);
        String typeName = argTypes[argIndex].getInternalName();
        return CodegenUtils.p(Object.class).equals(typeName);
    }

    private boolean isStoredIntoObjectArray(InstructionGraphNode node) {
        AbstractInsnNode insn = node.getInstruction();
        if (insn.getOpcode() != 83) {
            return false;
        }
        List<InstructionGraphNode> dependents = this.getDependents(node);
        Preconditions.checkState((dependents.size() == 1 ? 1 : 0) != 0);
        AbstractInsnNode newArrayInsn = dependents.get(0).getInstruction();
        Preconditions.checkState((newArrayInsn.getOpcode() == 189 ? 1 : 0) != 0);
        String desc = ((TypeInsnNode)newArrayInsn).desc;
        return CodegenUtils.p(Object.class).equals(desc);
    }

    private static int getArgumentIndex(InstructionGraphNode callNode, InstructionGraphNode predecessor) {
        int startIndex;
        for (int i = startIndex = callNode.getInstruction().getOpcode() == 184 ? 0 : 1; i < callNode.getPredecessors().size(); ++i) {
            InstructionGraphNode argumentNode = callNode.getPredecessors().get(i);
            if (!predecessor.equals((Object)argumentNode)) continue;
            return i - startIndex;
        }
        throw new IllegalStateException();
    }

    private List<InstructionGraphNode> getDependents(InstructionGraphNode predecessor) {
        ArrayList dependents = Lists.newArrayList();
        for (InstructionGraphNode node : this.method.getGraphNodes()) {
            if (!node.getPredecessors().contains((Object)predecessor)) continue;
            dependents.add(node);
        }
        return dependents;
    }

    private static MethodInsnNode createActionWrappingInsn() {
        return new MethodInsnNode(184, CodegenUtils.p(BaseParser.class), "ACTION", CodegenUtils.sig(Action.class, (Class[])new Class[]{Boolean.TYPE}), false);
    }
}

