/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform.process;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.RuleMethodInterpreter;
import org.parboiled.transform.process.RuleMethodProcessor;

public class InstructionGraphCreator
implements RuleMethodProcessor {
    @Override
    public boolean appliesTo(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) {
        Preconditions.checkNotNull((Object)((Object)classNode), (Object)"classNode");
        Preconditions.checkNotNull((Object)((Object)method), (Object)"method");
        return method.containsImplicitActions() || method.containsExplicitActions() || method.containsVars();
    }

    @Override
    public void process(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) throws Exception {
        Preconditions.checkNotNull((Object)((Object)method), (Object)"method");
        RuleMethodInterpreter interpreter = new RuleMethodInterpreter(method);
        RuleMethodAnalyzer analyzer = new RuleMethodAnalyzer(interpreter);
        analyzer.analyze(classNode.name, method);
        interpreter.finish();
    }

    private static final class RuleMethodAnalyzer
    extends Analyzer<BasicValue> {
        private final RuleMethodInterpreter rmi;

        private RuleMethodAnalyzer(RuleMethodInterpreter rmi) {
            super((Interpreter)Preconditions.checkNotNull((Object)((Object)rmi)));
            this.rmi = rmi;
        }

        protected void newControlFlowEdge(int insn, int successor) {
            this.rmi.newControlFlowEdge(insn, successor);
        }

        protected boolean newControlFlowExceptionEdge(int insn, int successor) {
            this.rmi.newControlFlowEdge(insn, successor);
            return true;
        }
    }
}

