/*
 * Decompiled with CFR 0.152.
 */
package com.github.pedrovgs.lynx;

import com.github.pedrovgs.lynx.model.TraceLevel;
import java.io.Serializable;

public class LynxConfig
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 293939299388293L;
    private static final float DEFAULT_TEXT_SIZE_IN_PX = 36.0f;
    private int maxNumberOfTracesToShow = 2500;
    private String filter = "";
    private TraceLevel filterTraceLevel = TraceLevel.VERBOSE;
    private Float textSizeInPx;
    private int samplingRate = 150;

    public LynxConfig setMaxNumberOfTracesToShow(int maxNumberOfTracesToShow) {
        if (maxNumberOfTracesToShow <= 0) {
            throw new IllegalArgumentException("You can't use a max number of traces equals or lower than zero.");
        }
        this.maxNumberOfTracesToShow = maxNumberOfTracesToShow;
        return this;
    }

    public LynxConfig setFilter(String filter) {
        if (filter == null) {
            throw new IllegalArgumentException("filter can't be null");
        }
        this.filter = filter;
        return this;
    }

    public LynxConfig setFilterTraceLevel(TraceLevel filterTraceLevel) {
        if (filterTraceLevel == null) {
            throw new IllegalArgumentException("filterTraceLevel can't be null");
        }
        this.filterTraceLevel = filterTraceLevel;
        return this;
    }

    public LynxConfig setTextSizeInPx(float textSizeInPx) {
        this.textSizeInPx = Float.valueOf(textSizeInPx);
        return this;
    }

    public LynxConfig setSamplingRate(int samplingRate) {
        this.samplingRate = samplingRate;
        return this;
    }

    public int getMaxNumberOfTracesToShow() {
        return this.maxNumberOfTracesToShow;
    }

    public String getFilter() {
        return this.filter;
    }

    public TraceLevel getFilterTraceLevel() {
        return this.filterTraceLevel;
    }

    public boolean hasFilter() {
        return !"".equals(this.filter) || !TraceLevel.VERBOSE.equals((Object)this.filterTraceLevel);
    }

    public float getTextSizeInPx() {
        return this.textSizeInPx == null ? 36.0f : this.textSizeInPx.floatValue();
    }

    public boolean hasTextSizeInPx() {
        return this.textSizeInPx != null;
    }

    public int getSamplingRate() {
        return this.samplingRate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LynxConfig)) {
            return false;
        }
        LynxConfig that = (LynxConfig)o;
        if (this.maxNumberOfTracesToShow != that.maxNumberOfTracesToShow) {
            return false;
        }
        if (this.samplingRate != that.samplingRate) {
            return false;
        }
        if (this.filter != null ? !this.filter.equals(that.filter) : that.filter != null) {
            return false;
        }
        if (this.textSizeInPx != null ? !this.textSizeInPx.equals(that.textSizeInPx) : that.textSizeInPx != null) {
            return false;
        }
        return this.filterTraceLevel == that.filterTraceLevel;
    }

    public int hashCode() {
        int result = this.maxNumberOfTracesToShow;
        result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
        result = 31 * result + (this.textSizeInPx != null ? this.textSizeInPx.hashCode() : 0);
        result = 31 * result + this.samplingRate;
        return result;
    }

    public Object clone() {
        return new LynxConfig().setMaxNumberOfTracesToShow(this.getMaxNumberOfTracesToShow()).setFilter(this.filter).setFilterTraceLevel(this.filterTraceLevel).setSamplingRate(this.getSamplingRate());
    }

    public String toString() {
        return "LynxConfig{maxNumberOfTracesToShow=" + this.maxNumberOfTracesToShow + ", filter='" + this.filter + '\'' + ", textSizeInPx=" + this.textSizeInPx + ", samplingRate=" + this.samplingRate + '}';
    }
}

