/*
 * Decompiled with CFR 0.152.
 */
package com.github.pedrovgs.lynx.model;

import android.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class Logcat
extends Thread
implements Cloneable {
    private static final String LOGTAG = "Logcat";
    private Process process;
    private BufferedReader bufferReader;
    private Listener listener;
    private boolean continueReading = true;

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public Listener getListener() {
        return this.listener;
    }

    @Override
    public void run() {
        super.run();
        try {
            this.process = Runtime.getRuntime().exec("logcat -v time");
        }
        catch (IOException e) {
            Log.e((String)LOGTAG, (String)"IOException executing logcat command.", (Throwable)e);
        }
        this.readLogcat();
    }

    public void stopReading() {
        this.continueReading = false;
    }

    private void readLogcat() {
        BufferedReader bufferedReader = this.getBufferReader();
        try {
            String trace = bufferedReader.readLine();
            while (trace != null && this.continueReading) {
                this.notifyListener(trace);
                trace = bufferedReader.readLine();
            }
        }
        catch (IOException e) {
            Log.e((String)LOGTAG, (String)"IOException reading logcat trace.", (Throwable)e);
        }
    }

    private void notifyListener(String trace) {
        if (this.listener != null) {
            this.listener.onTraceRead(trace);
        }
    }

    private BufferedReader getBufferReader() {
        if (this.bufferReader == null) {
            this.bufferReader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
        }
        return this.bufferReader;
    }

    @Override
    public Object clone() {
        return new Logcat();
    }

    static interface Listener {
        public void onTraceRead(String var1);
    }
}

