/*
 * Decompiled with CFR 0.152.
 */
package com.github.pedrovgs.lynx.model;

import android.util.Log;
import com.github.pedrovgs.lynx.LynxConfig;
import com.github.pedrovgs.lynx.exception.IllegalTraceException;
import com.github.pedrovgs.lynx.model.Logcat;
import com.github.pedrovgs.lynx.model.MainThread;
import com.github.pedrovgs.lynx.model.TimeProvider;
import com.github.pedrovgs.lynx.model.Trace;
import com.github.pedrovgs.lynx.model.TraceLevel;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Lynx {
    private static final String LOGTAG = "Lynx";
    private Logcat logcat;
    private final MainThread mainThread;
    private final TimeProvider timeProvider;
    private final List<Trace> tracesToNotify;
    private final List<Listener> listeners;
    private LynxConfig lynxConfig = new LynxConfig();
    private long lastNotificationTime;
    private String lowerCaseFilter = "";
    private Pattern regexpFilter;

    public Lynx(Logcat logcat, MainThread mainThread, TimeProvider timeProvider) {
        this.listeners = new LinkedList<Listener>();
        this.tracesToNotify = new LinkedList<Trace>();
        this.logcat = logcat;
        this.mainThread = mainThread;
        this.timeProvider = timeProvider;
        this.setFilters();
    }

    public synchronized void setConfig(LynxConfig lynxConfig) {
        this.lynxConfig = lynxConfig;
        this.setFilters();
    }

    public LynxConfig getConfig() {
        return (LynxConfig)this.lynxConfig.clone();
    }

    public void startReading() {
        this.logcat.setListener(new Logcat.Listener(){

            @Override
            public void onTraceRead(String logcatTrace) {
                try {
                    Lynx.this.addTraceToTheBuffer(logcatTrace);
                }
                catch (IllegalTraceException e) {
                    return;
                }
                Lynx.this.notifyNewTraces();
            }
        });
        boolean logcatWasNotStarted = Thread.State.NEW.equals((Object)this.logcat.getState());
        if (logcatWasNotStarted) {
            this.logcat.start();
        }
    }

    public void stopReading() {
        this.logcat.stopReading();
        this.logcat.interrupt();
    }

    public synchronized void restart() {
        Logcat.Listener previousListener = this.logcat.getListener();
        this.logcat.stopReading();
        this.logcat.interrupt();
        this.logcat = (Logcat)this.logcat.clone();
        this.logcat.setListener(previousListener);
        this.lastNotificationTime = 0L;
        this.tracesToNotify.clear();
        this.logcat.start();
    }

    public synchronized void registerListener(Listener lynxPresenter) {
        this.listeners.add(lynxPresenter);
    }

    public synchronized void unregisterListener(Listener lynxPresenter) {
        this.listeners.remove(lynxPresenter);
    }

    private void setFilters() {
        this.lowerCaseFilter = this.lynxConfig.getFilter().toLowerCase();
        try {
            this.regexpFilter = Pattern.compile(this.lowerCaseFilter);
        }
        catch (PatternSyntaxException exception) {
            this.regexpFilter = null;
            Log.d((String)LOGTAG, (String)"Invalid regexp filter!");
        }
    }

    private synchronized void addTraceToTheBuffer(String logcatTrace) throws IllegalTraceException {
        if (this.shouldAddTrace(logcatTrace)) {
            Trace trace = Trace.fromString(logcatTrace);
            this.tracesToNotify.add(trace);
        }
    }

    private boolean shouldAddTrace(String logcatTrace) {
        boolean hasFilterConfigured = this.lynxConfig.hasFilter();
        return !hasFilterConfigured || this.traceMatchesFilter(logcatTrace);
    }

    private synchronized boolean traceMatchesFilter(String logcatTrace) {
        return this.traceStringMatchesFilter(logcatTrace) && this.containsTraceLevel(logcatTrace, this.lynxConfig.getFilterTraceLevel());
    }

    private boolean traceStringMatchesFilter(String logcatTrace) {
        String lowerCaseLogcatTrace = logcatTrace.toLowerCase();
        boolean matchesFilter = lowerCaseLogcatTrace.contains(this.lowerCaseFilter);
        if (!matchesFilter && this.regexpFilter != null) {
            matchesFilter = this.regexpFilter.matcher(lowerCaseLogcatTrace).find();
        }
        return matchesFilter;
    }

    private boolean containsTraceLevel(String logcatTrace, TraceLevel levelFilter) {
        return levelFilter.equals((Object)TraceLevel.VERBOSE) || this.hasTraceLevelEqualOrHigher(logcatTrace, levelFilter);
    }

    private boolean hasTraceLevelEqualOrHigher(String logcatTrace, TraceLevel levelFilter) {
        TraceLevel level = TraceLevel.getTraceLevel(logcatTrace.charAt(19));
        return level.ordinal() >= levelFilter.ordinal();
    }

    private synchronized void notifyNewTraces() {
        if (this.shouldNotifyListeners()) {
            LinkedList<Trace> traces = new LinkedList<Trace>(this.tracesToNotify);
            this.tracesToNotify.clear();
            this.notifyListeners(traces);
        }
    }

    private synchronized boolean shouldNotifyListeners() {
        long now = this.timeProvider.getCurrentTimeMillis();
        long timeFromLastNotification = now - this.lastNotificationTime;
        boolean hasTracesToNotify = this.tracesToNotify.size() > 0;
        return timeFromLastNotification > (long)this.lynxConfig.getSamplingRate() && hasTracesToNotify;
    }

    private synchronized void notifyListeners(final List<Trace> traces) {
        this.mainThread.post(new Runnable(){

            @Override
            public void run() {
                for (Listener listener : Lynx.this.listeners) {
                    listener.onNewTraces(traces);
                }
                Lynx.this.lastNotificationTime = Lynx.this.timeProvider.getCurrentTimeMillis();
            }
        });
    }

    public static interface Listener {
        public void onNewTraces(List<Trace> var1);
    }
}

